/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.WalStateAckMessage;
import org.apache.ignite.internal.processors.cache.WalStateDistributedProcess;
import org.apache.ignite.internal.processors.cache.WalStateFinishMessage;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.processors.cache.WalStateResult;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointFuture;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashSet;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.OomExceptionHandler;
import org.jetbrains.annotations.Nullable;

public class WalStateManager
extends GridCacheSharedManagerAdapter {
    private static final int HIST_SIZE = 1000;
    private final GridBoundedConcurrentLinkedHashSet<T2<UUID, Boolean>> discoMsgIdHist = new GridBoundedConcurrentLinkedHashSet(1000);
    private final GridBoundedConcurrentLinkedHashSet<UUID> completedOpIds = new GridBoundedConcurrentLinkedHashSet(1000);
    private final Map<UUID, GridFutureAdapter<Boolean>> userFuts = new HashMap<UUID, GridFutureAdapter<Boolean>>();
    private final Map<UUID, WalStateResult> ress = new HashMap<UUID, WalStateResult>();
    private final Map<UUID, WalStateDistributedProcess> procs = new HashMap<UUID, WalStateDistributedProcess>();
    private final Collection<WalStateResult> initialRess = new LinkedList<WalStateResult>();
    private final Collection<WalStateAckMessage> pendingAcks = new HashSet<WalStateAckMessage>();
    private final boolean srv;
    private final GridMessageListener ioLsnr;
    private final Object mux = new Object();
    private final IgniteLogger log;
    private ClusterNode crdNode;
    private boolean disconnected;
    private volatile TemporaryDisabledWal tmpDisabledWal;
    private volatile WALDisableContext walDisableContext;

    public WalStateManager(GridKernalContext kernalCtx) {
        if (kernalCtx != null) {
            IgniteConfiguration cfg = kernalCtx.config();
            boolean client = cfg.isClientMode() != null && cfg.isClientMode() != false;
            this.srv = !client && !cfg.isDaemon();
            this.log = kernalCtx.log(WalStateManager.class);
        } else {
            this.srv = false;
            this.log = null;
        }
        this.ioLsnr = this.srv ? new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof WalStateAckMessage) {
                    WalStateAckMessage msg0 = (WalStateAckMessage)msg;
                    msg0.senderNodeId(nodeId);
                    WalStateManager.this.onAck(msg0);
                } else {
                    U.warn(WalStateManager.this.log, "Unexpected IO message (will ignore): " + msg);
                }
            }
        } : null;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        if (this.srv) {
            this.cctx.kernalContext().io().addMessageListener(GridTopic.TOPIC_WAL, this.ioLsnr);
        }
        this.walDisableContext = new WALDisableContext(this.cctx.cache().context().database(), this.cctx.pageStore(), this.log);
        this.cctx.kernalContext().internalSubscriptionProcessor().registerMetastorageListener(this.walDisableContext);
    }

    @Override
    protected void stop0(boolean cancel) {
        if (this.srv) {
            this.cctx.kernalContext().io().removeMessageListener(GridTopic.TOPIC_WAL, this.ioLsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCachesInfoCollected() {
        if (!this.srv) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            for (CacheGroupDescriptor grpDesc : this.cacheProcessor().cacheGroupDescriptors().values()) {
                WalStateResult res;
                boolean enabled;
                WalStateProposeMessage msg = grpDesc.nextWalChangeRequest();
                if (msg == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Processing WAL state message on start: " + msg);
                }
                if (F.eq(enabled = grpDesc.walEnabled(), msg.enable())) {
                    res = new WalStateResult(msg, false);
                } else {
                    res = new WalStateResult(msg, true);
                    grpDesc.walEnabled(!enabled);
                }
                this.initialRess.add(res);
                this.addResult(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKernalStart() {
        if (!this.srv) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            for (WalStateResult res : this.initialRess) {
                this.onCompletedLocally(res);
            }
            this.initialRess.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected(IgniteFuture reconnectFut) {
        ArrayList<GridFutureAdapter<Boolean>> userFuts0;
        Iterator iterator2 = this.mux;
        synchronized (iterator2) {
            assert (!this.disconnected);
            this.disconnected = true;
            userFuts0 = new ArrayList<GridFutureAdapter<Boolean>>(this.userFuts.values());
            this.userFuts.clear();
        }
        for (GridFutureAdapter gridFutureAdapter : userFuts0) {
            WalStateManager.completeWithError(gridFutureAdapter, "Client node was disconnected from topology (operation result is unknown).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReconnected(boolean active) {
        Object object = this.mux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<Boolean> init(Collection<String> cacheNames, boolean enabled) {
        if (F.isEmpty(cacheNames)) {
            return WalStateManager.errorFuture("Cache names cannot be empty.");
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.disconnected) {
                return WalStateManager.errorFuture("Failed to initiate WAL mode change because client node is disconnected.");
            }
            HashMap<String, IgniteUuid> caches = new HashMap<String, IgniteUuid>(cacheNames.size());
            CacheGroupDescriptor grpDesc = null;
            for (String cacheName : cacheNames) {
                DynamicCacheDescriptor cacheDesc = this.cacheProcessor().cacheDescriptor(cacheName);
                if (cacheDesc == null) {
                    return WalStateManager.errorFuture("Cache doesn't exist: " + cacheName);
                }
                caches.put(cacheName, cacheDesc.deploymentId());
                CacheGroupDescriptor curGrpDesc = cacheDesc.groupDescriptor();
                if (grpDesc == null) {
                    grpDesc = curGrpDesc;
                    continue;
                }
                if (F.eq(grpDesc.deploymentId(), curGrpDesc.deploymentId())) continue;
                return WalStateManager.errorFuture("Cannot change WAL mode for caches from different cache groups [cache1=" + cacheNames.iterator().next() + ", grp1=" + grpDesc.groupName() + ", cache2=" + cacheName + ", grp2=" + curGrpDesc.groupName() + ']');
            }
            assert (grpDesc != null);
            HashSet<String> grpCaches = new HashSet<String>(grpDesc.caches().keySet());
            grpCaches.removeAll(cacheNames);
            if (!grpCaches.isEmpty()) {
                return WalStateManager.errorFuture("Cannot change WAL mode because not all cache names belonging to the group are provided [group=" + grpDesc.groupName() + ", missingCaches=" + grpCaches + ']');
            }
            if (grpDesc.config().getCacheMode() == CacheMode.LOCAL) {
                return WalStateManager.errorFuture("WAL mode cannot be changed for LOCAL cache(s): " + cacheNames);
            }
            if (!grpDesc.persistenceEnabled()) {
                return WalStateManager.errorFuture("Cannot change WAL mode because persistence is not enabled for cache(s) [caches=" + cacheNames + ", dataRegion=" + grpDesc.config().getDataRegionName() + ']');
            }
            final UUID opId = UUID.randomUUID();
            GridFutureAdapter<Boolean> fut = new GridFutureAdapter<Boolean>();
            fut.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    Object object = WalStateManager.this.mux;
                    synchronized (object) {
                        WalStateManager.this.userFuts.remove(opId);
                    }
                }
            });
            WalStateProposeMessage msg = new WalStateProposeMessage(opId, grpDesc.groupId(), grpDesc.deploymentId(), this.cctx.localNodeId(), caches, enabled);
            this.userFuts.put(opId, fut);
            try {
                this.cctx.discovery().sendCustomEvent(msg);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Initiated WAL state change operation: " + msg);
                }
            }
            catch (Exception e) {
                IgniteCheckedException e0 = new IgniteCheckedException("Failed to initiate WAL mode change due to unexpected exception.", e);
                fut.onDone(e0);
            }
            return fut;
        }
    }

    public void changeLocalStatesOnExchangeDone(AffinityTopologyVersion topVer) {
        if (!IgniteSystemProperties.getBoolean("IGNITE_DISABLE_WAL_DURING_REBALANCING", false)) {
            return;
        }
        HashSet<Integer> grpsToEnableWal = new HashSet<Integer>();
        HashSet<Integer> grpsToDisableWal = new HashSet<Integer>();
        HashSet<Integer> grpsWithWalDisabled = new HashSet<Integer>();
        boolean hasNonEmptyOwning = false;
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal() || !grp.affinityNode() || !grp.persistenceEnabled()) continue;
            boolean hasOwning = false;
            boolean hasMoving = false;
            int parts = 0;
            for (GridDhtLocalPartition locPart : grp.topology().currentLocalPartitions()) {
                if (locPart.state() == GridDhtPartitionState.OWNING) {
                    hasOwning = true;
                    if (hasNonEmptyOwning) break;
                    if (locPart.updateCounter() > 0L) {
                        hasNonEmptyOwning = true;
                        break;
                    }
                    ++parts;
                }
                if (locPart.state() != GridDhtPartitionState.MOVING) continue;
                hasMoving = true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Prepare change WAL state, grp=" + grp.cacheOrGroupName() + ", grpId=" + grp.groupId() + ", hasOwning=" + hasOwning + ", hasMoving=" + hasMoving + ", WALState=" + grp.walEnabled() + ", parts=" + parts);
            }
            if (hasOwning && !grp.localWalEnabled()) {
                grpsToEnableWal.add(grp.groupId());
                continue;
            }
            if (hasMoving && !hasOwning && grp.localWalEnabled()) {
                grpsToDisableWal.add(grp.groupId());
                grpsWithWalDisabled.add(grp.groupId());
                continue;
            }
            if (grp.localWalEnabled()) continue;
            grpsWithWalDisabled.add(grp.groupId());
        }
        this.tmpDisabledWal = new TemporaryDisabledWal(grpsWithWalDisabled, topVer);
        if (grpsToEnableWal.isEmpty() && grpsToDisableWal.isEmpty()) {
            return;
        }
        try {
            if (hasNonEmptyOwning && !grpsToEnableWal.isEmpty()) {
                this.triggerCheckpoint("wal-local-state-change-" + topVer).finishFuture().get();
            }
        }
        catch (IgniteCheckedException ex) {
            throw new IgniteException(ex);
        }
        for (Integer grpId : grpsToEnableWal) {
            this.cctx.cache().cacheGroup(grpId).localWalEnabled(true);
        }
        for (Integer grpId : grpsToDisableWal) {
            this.cctx.cache().cacheGroup(grpId).localWalEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGroupRebalanceFinished(int grpId, AffinityTopologyVersion topVer) {
        final TemporaryDisabledWal session0 = this.tmpDisabledWal;
        if (session0 == null || !session0.topVer.equals(topVer)) {
            return;
        }
        session0.remainingGrps.remove(grpId);
        if (session0.remainingGrps.isEmpty()) {
            Object object = this.mux;
            synchronized (object) {
                if (this.tmpDisabledWal != session0) {
                    return;
                }
                for (Integer grpId0 : session0.disabledGrps) {
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId0);
                    assert (grp != null);
                    if (grp.localWalEnabled()) continue;
                    grp.localWalEnabled(true);
                }
                this.tmpDisabledWal = null;
            }
            CheckpointFuture cpFut = this.triggerCheckpoint("wal-local-state-changed-rebalance-finished-" + topVer);
            assert (cpFut != null);
            cpFut.finishFuture().listen((IgniteInClosure<IgniteInternalFuture<Object>>)new IgniteInClosureX<IgniteInternalFuture>(){

                @Override
                public void applyx(IgniteInternalFuture future) {
                    for (Integer grpId0 : session0.disabledGrps) {
                        CacheGroupContext grp = WalStateManager.this.cctx.cache().cacheGroup(grpId0);
                        assert (grp != null);
                        grp.topology().ownMoving(session0.topVer);
                    }
                    WalStateManager.this.cctx.exchange().refreshPartitions();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProposeDiscovery(WalStateProposeMessage msg) {
        if (this.isDuplicate(msg)) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.disconnected) {
                return;
            }
            if (this.validateProposeDiscovery(msg)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("WAL state change message is valid (will continue processing): " + msg);
                }
                CacheGroupDescriptor grpDesc = this.cacheProcessor().cacheGroupDescriptors().get(msg.groupId());
                assert (grpDesc != null);
                IgnitePredicate<ClusterNode> nodeFilter = grpDesc.config().getNodeFilter();
                boolean affNode = this.srv && (nodeFilter == null || nodeFilter.apply(this.cctx.localNode()));
                msg.affinityNode(affNode);
                if (grpDesc.addWalChangeRequest(msg)) {
                    msg.exchangeMessage(msg);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("WAL state change message will be processed in exchange thread: " + msg);
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("WAL state change message is added to pending set and will be processed later: " + msg);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("WAL state change message is invalid (will ignore): " + msg);
            }
        }
    }

    private boolean validateProposeDiscovery(WalStateProposeMessage msg) {
        GridFutureAdapter<Boolean> userFut = this.userFuts.get(msg.operationId());
        String errMsg = this.validate(msg);
        if (errMsg != null) {
            WalStateManager.completeWithError(userFut, errMsg);
            return false;
        }
        return true;
    }

    @Nullable
    private String validate(WalStateProposeMessage msg) {
        CacheGroupDescriptor grpDesc = this.cacheProcessor().cacheGroupDescriptors().get(msg.groupId());
        if (grpDesc == null) {
            return "Failed to change WAL mode because some caches no longer exist: " + msg.caches().keySet();
        }
        for (Map.Entry<String, IgniteUuid> cache : msg.caches().entrySet()) {
            String cacheName = cache.getKey();
            DynamicCacheDescriptor cacheDesc = this.cacheProcessor().cacheDescriptor(cacheName);
            if (cacheDesc != null && F.eq(cacheDesc.deploymentId(), cache.getValue())) continue;
            return "Cache doesn't exist: " + cacheName;
        }
        HashSet<String> grpCacheNames = new HashSet<String>(grpDesc.caches().keySet());
        grpCacheNames.removeAll(msg.caches().keySet());
        if (!grpCacheNames.isEmpty()) {
            return "Cannot change WAL mode because not all cache names belonging to the group are provided [group=" + grpDesc.groupName() + ", missingCaches=" + grpCacheNames + ']';
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProposeExchange(WalStateProposeMessage msg) {
        if (!this.srv) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            WalStateResult res;
            block16: {
                res = null;
                if (msg.affinityNode()) {
                    CacheGroupContext grpCtx = this.cacheProcessor().cacheGroup(msg.groupId());
                    if (grpCtx == null) {
                        res = new WalStateResult(msg, "Failed to change WAL mode because some caches no longer exist: " + msg.caches().keySet());
                    } else if (F.eq(msg.enable(), grpCtx.globalWalEnabled())) {
                        res = new WalStateResult(msg, false);
                    } else {
                        CheckpointFuture cpFut = this.triggerCheckpoint("wal-state-change-grp-" + msg.groupId());
                        if (cpFut != null) {
                            try {
                                cpFut.beginFuture().get();
                                if (msg.enable()) {
                                    grpCtx.globalWalEnabled(true);
                                    WalStateChangeWorker worker = new WalStateChangeWorker(msg, cpFut);
                                    IgniteThread thread = new IgniteThread(worker);
                                    thread.setUncaughtExceptionHandler(new OomExceptionHandler(this.cctx.kernalContext()));
                                    thread.start();
                                    break block16;
                                }
                                res = this.awaitCheckpoint(cpFut, msg);
                                grpCtx.globalWalEnabled(false);
                            }
                            catch (Exception e) {
                                U.warn(this.log, "Failed to change WAL mode due to unexpected exception [msg=" + msg + ']', e);
                                res = new WalStateResult(msg, "Failed to change WAL mode due to unexpected exception (see server logs for more information): " + e.getMessage());
                            }
                        } else {
                            res = new WalStateResult(msg, "Failed to initiate a checkpoint (checkpoint thread is not available).");
                        }
                    }
                } else {
                    res = new WalStateResult(msg, false);
                }
            }
            if (res != null) {
                this.addResult(res);
                this.onCompletedLocally(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletedLocally(WalStateResult res) {
        assert (res != null);
        Object object = this.mux;
        synchronized (object) {
            ClusterNode crdNode = this.coordinator();
            UUID opId = res.message().operationId();
            WalStateAckMessage msg = new WalStateAckMessage(opId, res.message().affinityNode(), res.changed(), res.errorMessage());
            if (crdNode.isLocal()) {
                Collection<ClusterNode> srvNodes = this.cctx.discovery().aliveServerNodes();
                ArrayList<UUID> srvNodeIds = new ArrayList<UUID>(srvNodes.size());
                for (ClusterNode srvNode : srvNodes) {
                    if (!this.cctx.discovery().alive(srvNode)) continue;
                    srvNodeIds.add(srvNode.id());
                }
                WalStateDistributedProcess proc = new WalStateDistributedProcess(res.message(), srvNodeIds);
                this.procs.put(res.message().operationId(), proc);
                this.unwindPendingAcks(proc);
                proc.onNodeFinished(this.cctx.localNodeId(), msg);
                this.sendFinishMessageIfNeeded(proc);
            } else {
                try {
                    this.cctx.kernalContext().io().sendToGridTopic(crdNode, GridTopic.TOPIC_WAL, (Message)msg, (byte)2);
                }
                catch (IgniteCheckedException e) {
                    U.warn(this.log, "Failed to send ack message to coordinator node [opId=" + opId + ", node=" + crdNode.id() + ']');
                }
            }
        }
    }

    private void unwindPendingAcks(WalStateDistributedProcess proc) {
        assert (Thread.holdsLock(this.mux));
        Iterator<WalStateAckMessage> iter2 = this.pendingAcks.iterator();
        while (iter2.hasNext()) {
            WalStateAckMessage ackMsg = iter2.next();
            if (!F.eq(proc.operationId(), ackMsg.operationId())) continue;
            proc.onNodeFinished(ackMsg.senderNodeId(), ackMsg);
            iter2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAck(WalStateAckMessage msg) {
        Object object = this.mux;
        synchronized (object) {
            if (this.completedOpIds.contains(msg.operationId())) {
                return;
            }
            WalStateDistributedProcess proc = this.procs.get(msg.operationId());
            if (proc == null) {
                this.pendingAcks.add(msg);
            } else {
                proc.onNodeFinished(msg.senderNodeId(), msg);
                this.sendFinishMessageIfNeeded(proc);
            }
        }
    }

    private void sendFinishMessageIfNeeded(WalStateDistributedProcess proc) {
        if (proc.completed()) {
            this.sendFinishMessage(proc.prepareFinishMessage());
        }
    }

    private void sendFinishMessage(WalStateFinishMessage finishMsg) {
        try {
            this.cctx.discovery().sendCustomEvent(finishMsg);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to send WAL mode change finish message due to unexpected exception: " + finishMsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishDiscovery(WalStateFinishMessage msg) {
        if (this.isDuplicate(msg)) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            WalStateResult res;
            if (this.disconnected) {
                return;
            }
            GridFutureAdapter<Boolean> userFut = this.userFuts.get(msg.operationId());
            if (userFut != null) {
                if (msg.errorMessage() != null) {
                    WalStateManager.completeWithError(userFut, msg.errorMessage());
                } else {
                    WalStateManager.complete(userFut, msg.changed());
                }
            }
            if ((res = this.ress.remove(msg.operationId())) == null && this.srv) {
                U.warn(this.log, "Received finish message for unknown operation (will ignore): " + msg.operationId());
            }
            this.procs.remove(msg.operationId());
            CacheGroupDescriptor grpDesc = this.cacheProcessor().cacheGroupDescriptors().get(msg.groupId());
            if (grpDesc != null && F.eq(grpDesc.deploymentId(), msg.groupDeploymentId())) {
                if (msg.changed()) {
                    grpDesc.walEnabled(!grpDesc.walEnabled());
                }
                WalStateProposeMessage oldProposeMsg = grpDesc.nextWalChangeRequest();
                assert (oldProposeMsg != null);
                assert (F.eq(oldProposeMsg.operationId(), msg.operationId()));
                grpDesc.removeWalChangeRequest();
                WalStateProposeMessage nextProposeMsg = grpDesc.nextWalChangeRequest();
                if (nextProposeMsg != null) {
                    msg.exchangeMessage(nextProposeMsg);
                }
            }
            if (this.srv) {
                this.completedOpIds.add(msg.operationId());
                Iterator<WalStateAckMessage> ackIter = this.pendingAcks.iterator();
                while (ackIter.hasNext()) {
                    WalStateAckMessage ackMsg = ackIter.next();
                    if (!F.eq(ackMsg.operationId(), msg.operationId())) continue;
                    ackIter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeft(UUID nodeId) {
        if (!this.srv) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.crdNode == null) {
                assert (this.ress.isEmpty());
                assert (this.procs.isEmpty());
                return;
            }
            if (F.eq(this.crdNode.id(), nodeId)) {
                this.crdNode = null;
                for (WalStateResult res : this.ress.values()) {
                    this.onCompletedLocally(res);
                }
            } else if (F.eq(this.cctx.localNodeId(), this.crdNode.id())) {
                for (Map.Entry<UUID, WalStateDistributedProcess> procEntry : this.procs.entrySet()) {
                    WalStateDistributedProcess proc = procEntry.getValue();
                    proc.onNodeLeft(nodeId);
                    this.sendFinishMessageIfNeeded(proc);
                }
            }
        }
    }

    private static IgniteInternalFuture<Boolean> errorFuture(String errMsg) {
        return new GridFinishedFuture<Boolean>(new IgniteCheckedException(errMsg));
    }

    private static void complete(@Nullable GridFutureAdapter<Boolean> userFut, boolean res) {
        if (userFut != null) {
            userFut.onDone(res);
        }
    }

    private static void completeWithError(@Nullable GridFutureAdapter<Boolean> userFut, String errMsg) {
        if (userFut != null) {
            userFut.onDone(new IgniteCheckedException(errMsg));
        }
    }

    private GridCacheProcessor cacheProcessor() {
        return this.cctx.cache();
    }

    private ClusterNode coordinator() {
        assert (Thread.holdsLock(this.mux));
        if (this.crdNode != null) {
            return this.crdNode;
        }
        ClusterNode res = null;
        for (ClusterNode node : this.cctx.discovery().aliveServerNodes()) {
            if (res != null && res.order() <= node.order()) continue;
            res = node;
        }
        assert (res != null);
        this.crdNode = res;
        return res;
    }

    private boolean isDuplicate(WalStateAbstractMessage msg) {
        T2<UUID, Boolean> key;
        if (msg instanceof WalStateProposeMessage) {
            key = new T2<UUID, Boolean>(msg.operationId(), true);
        } else {
            assert (msg instanceof WalStateFinishMessage);
            key = new T2<UUID, Boolean>(msg.operationId(), false);
        }
        if (!this.discoMsgIdHist.add(key)) {
            U.warn(this.log, "Received duplicate WAL mode change discovery message (will ignore): " + msg);
            return true;
        }
        return false;
    }

    private void addResult(WalStateResult res) {
        this.ress.put(res.message().operationId(), res);
    }

    @Nullable
    private CheckpointFuture triggerCheckpoint(String msg) {
        return this.cctx.database().forceCheckpoint(msg);
    }

    private WalStateResult awaitCheckpoint(CheckpointFuture cpFut, WalStateProposeMessage msg) {
        WalStateResult res;
        try {
            assert (msg.affinityNode());
            if (cpFut != null) {
                cpFut.finishFuture().get();
            }
            res = new WalStateResult(msg, true);
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to change WAL mode due to unexpected exception [msg=" + msg + ']', e);
            res = new WalStateResult(msg, "Failed to change WAL mode due to unexpected exception (see server logs for more information): " + e.getMessage());
        }
        return res;
    }

    public boolean isDisabled(int grpId) {
        CacheGroupContext ctx = this.cctx.cache().cacheGroup(grpId);
        return ctx != null && !ctx.walEnabled();
    }

    public WALDisableContext walDisableContext() {
        return this.walDisableContext;
    }

    public void runWithOutWAL(IgniteRunnable cls) throws IgniteCheckedException {
        WALDisableContext ctx = this.walDisableContext;
        if (ctx == null) {
            throw new IgniteCheckedException("Disable WAL context is not initialized.");
        }
        ctx.execute(cls);
    }

    public static class WALDisableContext
    implements MetastorageLifecycleListener {
        public static final String WAL_DISABLED = "wal-disabled";
        private final IgniteLogger log;
        private final IgniteCacheDatabaseSharedManager dbMgr;
        private volatile ReadWriteMetastorage metaStorage;
        private final IgnitePageStoreManager pageStoreMgr;
        private volatile boolean resetWalFlag;
        private volatile boolean disableWal;

        public WALDisableContext(IgniteCacheDatabaseSharedManager dbMgr, IgnitePageStoreManager pageStoreMgr, @Nullable IgniteLogger log2) {
            this.dbMgr = dbMgr;
            this.pageStoreMgr = pageStoreMgr;
            this.log = log2;
        }

        public void execute(IgniteRunnable cls) throws IgniteCheckedException {
            if (cls == null) {
                throw new IgniteCheckedException("Task to execute is not specified.");
            }
            if (this.metaStorage == null) {
                throw new IgniteCheckedException("Meta storage is not ready.");
            }
            this.writeMetaStoreDisableWALFlag();
            this.dbMgr.waitForCheckpoint("Checkpoint before apply updates on recovery.");
            this.disableWAL(true);
            try {
                cls.run();
            }
            catch (IgniteException e) {
                throw new IgniteCheckedException(e);
            }
            finally {
                this.disableWAL(false);
                this.dbMgr.waitForCheckpoint("Checkpoint after apply updates on recovery.");
                this.removeMetaStoreDisableWALFlag();
            }
        }

        protected void writeMetaStoreDisableWALFlag() throws IgniteCheckedException {
            this.dbMgr.checkpointReadLock();
            try {
                this.metaStorage.write(WAL_DISABLED, Boolean.TRUE);
            }
            finally {
                this.dbMgr.checkpointReadUnlock();
            }
        }

        protected void removeMetaStoreDisableWALFlag() throws IgniteCheckedException {
            this.dbMgr.checkpointReadLock();
            try {
                this.metaStorage.remove(WAL_DISABLED);
            }
            finally {
                this.dbMgr.checkpointReadUnlock();
            }
        }

        protected void disableWAL(boolean disable) throws IgniteCheckedException {
            this.dbMgr.checkpointReadLock();
            try {
                this.disableWal = disable;
                if (this.log != null) {
                    this.log.info("WAL logging " + (disable ? "disabled" : "enabled"));
                }
            }
            finally {
                this.dbMgr.checkpointReadUnlock();
            }
        }

        @Override
        public void onReadyForRead(ReadOnlyMetastorage ms) throws IgniteCheckedException {
            Boolean disabled = (Boolean)ms.read(WAL_DISABLED);
            if (disabled != null && disabled.booleanValue()) {
                this.resetWalFlag = true;
                this.pageStoreMgr.cleanupPersistentSpace();
                this.dbMgr.cleanupTempCheckpointDirectory();
                this.dbMgr.cleanupCheckpointDirectory();
            }
        }

        @Override
        public void onReadyForReadWrite(ReadWriteMetastorage ms) throws IgniteCheckedException {
            if (this.resetWalFlag) {
                ms.remove(WAL_DISABLED);
            }
            this.metaStorage = ms;
        }

        public boolean check() {
            return this.disableWal;
        }
    }

    private static class TemporaryDisabledWal {
        private final Set<Integer> disabledGrps;
        private final Set<Integer> remainingGrps;
        private final AffinityTopologyVersion topVer;

        public TemporaryDisabledWal(Set<Integer> disabledGrps, AffinityTopologyVersion topVer) {
            this.disabledGrps = Collections.unmodifiableSet(disabledGrps);
            this.remainingGrps = new HashSet<Integer>(disabledGrps);
            this.topVer = topVer;
        }
    }

    private class WalStateChangeWorker
    extends GridWorker {
        private final WalStateProposeMessage msg;
        private final CheckpointFuture cpFut;

        private WalStateChangeWorker(WalStateProposeMessage msg, CheckpointFuture cpFut) {
            super(WalStateManager.this.cctx.igniteInstanceName(), "wal-state-change-worker-" + msg.groupId(), WalStateManager.this.log);
            this.msg = msg;
            this.cpFut = cpFut;
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            WalStateResult res = WalStateManager.this.awaitCheckpoint(this.cpFut, this.msg);
            WalStateManager.this.addResult(res);
            WalStateManager.this.onCompletedLocally(res);
        }
    }
}

