/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.WalStateAckMessage;
import org.apache.ignite.internal.processors.cache.WalStateFinishMessage;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class WalStateDistributedProcess {
    private final WalStateProposeMessage msg;
    @GridToStringInclude
    private final Collection<UUID> remainingNodes;
    private final Map<UUID, WalStateAckMessage> acks;

    public WalStateDistributedProcess(WalStateProposeMessage msg, Collection<UUID> remainingNodes) {
        assert (!F.isEmpty(remainingNodes));
        this.msg = msg;
        this.remainingNodes = remainingNodes;
        this.acks = new HashMap<UUID, WalStateAckMessage>(remainingNodes.size());
    }

    public void onNodeFinished(UUID nodeId, WalStateAckMessage ack) {
        this.remainingNodes.remove(nodeId);
        if (ack.affNode()) {
            this.acks.put(nodeId, ack);
        }
    }

    public void onNodeLeft(UUID nodeId) {
        this.remainingNodes.remove(nodeId);
    }

    public boolean completed() {
        return this.remainingNodes.isEmpty();
    }

    public UUID operationId() {
        return this.msg.operationId();
    }

    public WalStateFinishMessage prepareFinishMessage() {
        assert (this.completed());
        if (this.acks.isEmpty()) {
            return new WalStateFinishMessage(this.msg.operationId(), this.msg.groupId(), this.msg.groupDeploymentId(), false, "Operation result is unknown because all affinity nodes have left the grid.");
        }
        HashMap<Object, String> errs = new HashMap<Object, String>();
        for (Map.Entry<UUID, WalStateAckMessage> ackEntry : this.acks.entrySet()) {
            UUID nodeId = ackEntry.getKey();
            WalStateAckMessage walStateAckMessage = ackEntry.getValue();
            assert (walStateAckMessage.affNode());
            if (walStateAckMessage.errorMessage() == null) continue;
            errs.put(nodeId, walStateAckMessage.errorMessage());
        }
        if (!errs.isEmpty()) {
            SB errMsg = new SB("Operation failed on some nodes (please consult to node logs for more information) [");
            boolean first = true;
            for (Map.Entry entry2 : errs.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    errMsg.a(", ");
                }
                errMsg.a("[nodeId=" + entry2.getKey() + ", err=" + (String)entry2.getValue() + ']');
            }
            errMsg.a(']');
            return new WalStateFinishMessage(this.msg.operationId(), this.msg.groupId(), this.msg.groupDeploymentId(), false, errMsg.toString());
        }
        Boolean changed = null;
        for (WalStateAckMessage ackMsg : this.acks.values()) {
            boolean bl = ackMsg.changed();
            if (changed == null) {
                changed = bl;
                continue;
            }
            if (F.eq(bl, changed)) continue;
            return new WalStateFinishMessage(this.msg.operationId(), this.msg.groupId(), this.msg.groupDeploymentId(), false, "Operation result is unknown because nodes reported different results (please re-try operation).");
        }
        assert (changed != null);
        return new WalStateFinishMessage(this.msg.operationId(), this.msg.groupId(), this.msg.groupDeploymentId(), changed, null);
    }

    public String toString() {
        return S.toString(WalStateDistributedProcess.class, this);
    }
}

