/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteLogger;
import org.jetbrains.annotations.NotNull;

public class PartitionUpdateCounter {
    private IgniteLogger log;
    private final TreeSet<Item> queue = new TreeSet();
    private final AtomicLong cntr = new AtomicLong();
    private long initCntr;

    PartitionUpdateCounter(IgniteLogger log2) {
        this.log = log2;
    }

    public void init(long updateCntr) {
        this.initCntr = updateCntr;
        this.cntr.set(updateCntr);
    }

    public long initial() {
        return this.initCntr;
    }

    public long get() {
        return this.cntr.get();
    }

    public long getAndAdd(long delta) {
        return this.cntr.getAndAdd(delta);
    }

    public long next() {
        return this.cntr.incrementAndGet();
    }

    public void update(long val) {
        long val0;
        while ((val0 = this.cntr.get()) < val && !this.cntr.compareAndSet(val0, val)) {
        }
    }

    public synchronized void update(long start, long delta) {
        long cur = this.cntr.get();
        if (cur > start) {
            this.log.warning("Stale update counter task [cur=" + cur + ", start=" + start + ", delta=" + delta + ']');
            return;
        }
        if (cur < start) {
            this.offer(new Item(start, delta));
            return;
        }
        while (true) {
            long next2 = start + delta;
            boolean res = this.cntr.compareAndSet(cur, next2);
            assert (res);
            Item peek2 = this.peek();
            if (peek2 == null || peek2.start != next2) {
                return;
            }
            Item item = this.poll();
            assert (peek2 == item);
            start = item.start;
            delta = item.delta;
            cur = next2;
        }
    }

    public void updateInitial(long cntr) {
        if (this.get() < cntr) {
            this.update(cntr);
        }
        this.initCntr = cntr;
    }

    private Item poll() {
        return this.queue.pollFirst();
    }

    private Item peek() {
        return this.queue.isEmpty() ? null : this.queue.first();
    }

    private void offer(Item item) {
        this.queue.add(item);
    }

    public synchronized void finalizeUpdateCountres() {
        Item last2 = this.queue.pollLast();
        if (last2 != null) {
            this.update(last2.start + last2.delta);
        }
        this.queue.clear();
    }

    private static class Item
    implements Comparable<Item> {
        private final long start;
        private final long delta;

        private Item(long start, long delta) {
            this.start = start;
            this.delta = delta;
        }

        @Override
        public int compareTo(@NotNull Item o) {
            return Long.compare(this.start, o.start);
        }
    }
}

