/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;

public class LocalJoinCachesContext {
    @GridToStringInclude
    private List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> locJoinStartCaches = Collections.emptyList();
    @GridToStringInclude
    private Map<Integer, CacheGroupDescriptor> cacheGrpDescs;
    @GridToStringInclude
    private Map<String, DynamicCacheDescriptor> cacheDescs;

    public LocalJoinCachesContext(List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> locJoinStartCaches, Map<Integer, CacheGroupDescriptor> cacheGrpDescs, Map<String, DynamicCacheDescriptor> cacheDescs) {
        this.locJoinStartCaches = locJoinStartCaches;
        this.cacheGrpDescs = cacheGrpDescs;
        this.cacheDescs = cacheDescs;
    }

    public List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> caches() {
        return this.locJoinStartCaches;
    }

    public Map<Integer, CacheGroupDescriptor> cacheGroupDescriptors() {
        return this.cacheGrpDescs;
    }

    public Map<String, DynamicCacheDescriptor> cacheDescriptors() {
        return this.cacheDescs;
    }

    public void removeSurvivedCaches(Set<String> cacheNames) {
        Iterator<T2<DynamicCacheDescriptor, NearCacheConfiguration>> it = this.locJoinStartCaches.iterator();
        while (it.hasNext()) {
            T2<DynamicCacheDescriptor, NearCacheConfiguration> entry2 = it.next();
            DynamicCacheDescriptor desc = (DynamicCacheDescriptor)entry2.get1();
            if (!cacheNames.contains(desc.cacheName())) continue;
            it.remove();
        }
    }

    public boolean isEmpty() {
        return F.isEmpty(this.locJoinStartCaches) && F.isEmpty(this.cacheGrpDescs) && F.isEmpty(this.cacheDescs);
    }

    public String toString() {
        return S.toString(LocalJoinCachesContext.class, this);
    }
}

