/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.jetbrains.annotations.Nullable;

class GridCacheLoaderWriterStore<K, V>
implements CacheStore<K, V>,
LifecycleAware,
Serializable {
    private static final long serialVersionUID = 0L;
    private final CacheLoader<K, V> ldr;
    private final CacheWriter<K, V> writer;

    GridCacheLoaderWriterStore(@Nullable CacheLoader<K, V> ldr, @Nullable CacheWriter<K, V> writer) {
        assert (ldr != null || writer != null);
        this.ldr = ldr;
        this.writer = writer;
    }

    CacheLoader<K, V> loader() {
        return this.ldr;
    }

    CacheWriter<K, V> writer() {
        return this.writer;
    }

    @Override
    public void start() {
        if (this.ldr instanceof LifecycleAware) {
            ((LifecycleAware)((Object)this.ldr)).start();
        }
        if (this.writer instanceof LifecycleAware) {
            ((LifecycleAware)((Object)this.writer)).start();
        }
    }

    @Override
    public void stop() {
        if (this.ldr instanceof LifecycleAware) {
            ((LifecycleAware)((Object)this.ldr)).stop();
        } else if (this.ldr instanceof Closeable) {
            U.closeQuiet((Closeable)((Object)this.ldr));
        }
        if (this.writer instanceof LifecycleAware) {
            ((LifecycleAware)((Object)this.writer)).stop();
        } else if (this.writer instanceof Closeable) {
            U.closeQuiet((Closeable)((Object)this.writer));
        }
    }

    @Override
    public void loadCache(IgniteBiInClosure<K, V> clo, Object ... args2) {
    }

    @Override
    @Nullable
    public V load(K key) {
        if (this.ldr == null) {
            return null;
        }
        return this.ldr.load(key);
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        if (this.ldr == null) {
            return Collections.emptyMap();
        }
        return this.ldr.loadAll(keys);
    }

    @Override
    public void write(Cache.Entry<? extends K, ? extends V> entry2) {
        if (this.writer == null) {
            return;
        }
        this.writer.write(entry2);
    }

    @Override
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        if (this.writer == null) {
            return;
        }
        this.writer.writeAll(entries);
    }

    @Override
    public void delete(Object key) {
        if (this.writer == null) {
            return;
        }
        this.writer.delete(key);
    }

    @Override
    public void deleteAll(Collection<?> keys) {
        if (this.writer == null) {
            return;
        }
        this.writer.deleteAll(keys);
    }

    @Override
    public void sessionEnd(boolean commit2) {
    }

    public String toString() {
        return S.toString(GridCacheLoaderWriterStore.class, this);
    }
}

