/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.GridSerializableIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class GridCacheIterator<K, V, T>
implements GridSerializableIterator<T> {
    private static final long serialVersionUID = 0L;
    private final Iterator<? extends Cache.Entry<K, V>> it;
    private final IgniteClosure<Cache.Entry<K, V>, T> trans;
    private Cache.Entry<K, V> cur;
    private GridCacheContext<K, V> cctx;

    public GridCacheIterator(GridCacheContext<K, V> cctx, Iterable<? extends Cache.Entry<K, V>> c, IgniteClosure<Cache.Entry<K, V>, T> trans, IgnitePredicate<Cache.Entry<K, V>>[] filter2) {
        this.cctx = cctx;
        this.it = F.iterator0(c, false, filter2);
        this.trans = trans;
    }

    @Override
    public boolean hasNext() {
        if (!this.it.hasNext()) {
            this.cur = null;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        this.cur = this.it.next();
        return this.trans.apply(this.cur);
    }

    @Override
    public void remove() {
        this.it.remove();
        this.cctx.grid().cache(this.cctx.name()).remove(this.cur.getKey(), this.cur.getValue());
    }
}

