/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheEntryInfo
implements Message {
    private static final int SIZE_OVERHEAD = 76;
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private KeyCacheObject key;
    private int cacheId;
    private CacheObject val;
    private long ttl;
    private long expireTime;
    private GridCacheVersion ver;
    @GridDirectTransient
    private boolean isNew;
    @GridDirectTransient
    private boolean deleted;

    public int cacheId() {
        return this.cacheId;
    }

    public void cacheId(int cacheId) {
        this.cacheId = cacheId;
    }

    public void key(KeyCacheObject key) {
        this.key = key;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject value() {
        return this.val;
    }

    public void value(CacheObject val) {
        this.val = val;
    }

    public long expireTime() {
        return this.expireTime;
    }

    public void expireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public long ttl() {
        return this.ttl;
    }

    public void ttl(long ttl) {
        this.ttl = ttl;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public void version(GridCacheVersion ver) {
        this.ver = ver;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("expireTime", this.expireTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("ttl", this.ttl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.expireTime = reader.readLong("expireTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.ttl = reader.readLong("ttl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheEntryInfo.class);
    }

    @Override
    public short directType() {
        return 91;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    public void unmarshalValue(GridCacheContext<?, ?> ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.val != null) {
            this.val.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    public int marshalledSize(CacheObjectContext ctx) throws IgniteCheckedException {
        int size2 = 0;
        if (this.val != null) {
            size2 += this.val.valueBytes(ctx).length;
        }
        return 76 + (size2 += this.key.valueBytes(ctx).length);
    }

    public void marshal(GridCacheContext ctx) throws IgniteCheckedException {
        this.marshal(ctx.cacheObjectContext());
    }

    public void marshal(CacheObjectContext ctx) throws IgniteCheckedException {
        assert (this.key != null);
        this.key.prepareMarshal(ctx);
        if (this.val != null) {
            this.val.prepareMarshal(ctx);
        }
        if (this.expireTime == 0L) {
            this.expireTime = -1L;
        } else {
            this.expireTime -= U.currentTimeMillis();
            if (this.expireTime < 0L) {
                this.expireTime = 0L;
            }
        }
    }

    public void unmarshal(GridCacheContext ctx, ClassLoader clsLdr) throws IgniteCheckedException {
        this.unmarshal(ctx.cacheObjectContext(), clsLdr);
    }

    public void unmarshal(CacheObjectContext ctx, ClassLoader clsLdr) throws IgniteCheckedException {
        long remaining;
        this.key.finishUnmarshal(ctx, clsLdr);
        if (this.val != null) {
            this.val.finishUnmarshal(ctx, clsLdr);
        }
        long l = this.expireTime = (remaining = this.expireTime) < 0L ? 0L : U.currentTimeMillis() + remaining;
        if (this.expireTime < 0L) {
            this.expireTime = 0L;
        }
    }

    public String toString() {
        return S.toString(GridCacheEntryInfo.class, this);
    }
}

