/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheCompoundFuture<T, R>
extends GridCompoundFuture<T, R>
implements GridCacheFuture<R> {
    private final long startTime = U.currentTimeMillis();
    private volatile long endTime;

    protected GridCacheCompoundFuture(@Nullable IgniteReducer<T, R> rdc) {
        super(rdc);
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long duration() {
        long endTime = this.endTime;
        return (endTime == 0L ? U.currentTimeMillis() : endTime) - this.startTime;
    }

    @Override
    protected boolean onDone(@Nullable R res, @Nullable Throwable err2, boolean cancel) {
        if (super.onDone(res, err2, cancel)) {
            this.endTime = U.currentTimeMillis();
            return true;
        }
        return false;
    }
}

