/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheIteratorConverter;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheWeakQueryIteratorsHolder<V> {
    private final ReferenceQueue refQueue = new ReferenceQueue();
    private final Map<WeakReference, AutoCloseable> refs = new ConcurrentHashMap<WeakReference, AutoCloseable>();
    private final IgniteLogger log;

    public CacheWeakQueryIteratorsHolder(IgniteLogger log2) {
        this.log = log2;
    }

    public <T> WeakReferenceCloseableIterator<T> iterator(CacheQueryFuture<V> fut, CacheIteratorConverter<T, V> convert2) {
        WeakQueryFutureIterator<T> it = new WeakQueryFutureIterator<T>(fut, convert2);
        AutoCloseable old = this.refs.put(it.weakReference(), fut);
        assert (old == null);
        return it;
    }

    public <T> WeakReferenceCloseableIterator<T> iterator(GridCloseableIterator<V> iter2, CacheIteratorConverter<T, V> convert2) {
        WeakQueryCloseableIterator<T> it = new WeakQueryCloseableIterator<T>(iter2, convert2);
        AutoCloseable old = this.refs.put(it.weakReference(), iter2);
        assert (old == null);
        return it;
    }

    public void removeIterator(WeakReferenceCloseableIterator it) throws IgniteCheckedException {
        this.refs.remove(it.weakReference());
        it.close();
    }

    public void checkWeakQueue() {
        Reference itRef = this.refQueue.poll();
        while (itRef != null) {
            try {
                WeakReference weakRef = (WeakReference)itRef;
                AutoCloseable rsrc = this.refs.remove(weakRef);
                if (rsrc != null) {
                    rsrc.close();
                }
            }
            catch (Exception e) {
                U.error(this.log, "Failed to close iterator.", e);
            }
            itRef = this.refQueue.poll();
        }
    }

    public void clearQueries() {
        for (AutoCloseable rsrc : this.refs.values()) {
            try {
                rsrc.close();
            }
            catch (Exception e) {
                U.error(this.log, "Failed to close iterator.", e);
            }
        }
        this.refs.clear();
    }

    public static interface WeakReferenceCloseableIterator<T>
    extends GridCloseableIterator<T> {
        public WeakReference weakReference();
    }

    public class WeakQueryCloseableIterator<T>
    extends GridCloseableIteratorAdapter<T>
    implements WeakReferenceCloseableIterator<T> {
        private static final long serialVersionUID = 0L;
        private final GridCloseableIterator<V> iter;
        private final CacheIteratorConverter<T, V> convert;
        private final WeakReference weakRef;
        private T cur;

        WeakQueryCloseableIterator(GridCloseableIterator<V> iter2, CacheIteratorConverter<T, V> convert2) {
            this.iter = iter2;
            this.convert = convert2;
            this.weakRef = new WeakReference<WeakQueryCloseableIterator>(this, CacheWeakQueryIteratorsHolder.this.refQueue);
        }

        @Override
        protected T onNext() throws IgniteCheckedException {
            Object next2;
            try {
                next2 = this.iter.nextX();
            }
            catch (NoSuchElementException e) {
                this.clearWeakReference();
                throw e;
            }
            if (next2 == null) {
                this.clearWeakReference();
            }
            this.cur = next2 != null ? this.convert.convert(next2) : null;
            return this.cur;
        }

        @Override
        protected boolean onHasNext() throws IgniteCheckedException {
            boolean hasNextX = this.iter.hasNextX();
            if (!hasNextX) {
                this.clearWeakReference();
            }
            return hasNextX;
        }

        @Override
        protected void onRemove() throws IgniteCheckedException {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            this.convert.remove(this.cur);
            this.cur = null;
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            this.iter.close();
            this.clearWeakReference();
        }

        private void clearWeakReference() {
            this.weakRef.clear();
            CacheWeakQueryIteratorsHolder.this.refs.remove(this.weakRef);
        }

        @Override
        public WeakReference weakReference() {
            return this.weakRef;
        }
    }

    private class WeakQueryFutureIterator<T>
    extends GridCloseableIteratorAdapter<T>
    implements WeakReferenceCloseableIterator<T> {
        private static final long serialVersionUID = 0L;
        private final CacheQueryFuture<V> fut;
        private final WeakReference<WeakQueryFutureIterator<T>> weakRef;
        private final CacheIteratorConverter<T, V> convert;
        private boolean init;
        private T next;
        private T cur;

        WeakQueryFutureIterator(CacheQueryFuture<V> fut, CacheIteratorConverter<T, V> convert2) {
            this.fut = fut;
            this.weakRef = new WeakReference<WeakQueryFutureIterator>(this, CacheWeakQueryIteratorsHolder.this.refQueue);
            this.convert = convert2;
        }

        @Override
        public T onNext() throws IgniteCheckedException {
            this.init();
            if (this.next == null) {
                this.clearWeakReference();
                throw new NoSuchElementException();
            }
            this.cur = this.next;
            Object futNext = this.fut.next();
            if (futNext == null) {
                this.clearWeakReference();
            }
            this.next = futNext != null ? this.convert.convert(futNext) : null;
            return this.cur;
        }

        @Override
        public boolean onHasNext() throws IgniteCheckedException {
            boolean hasNext;
            this.init();
            boolean bl = hasNext = this.next != null;
            if (!hasNext) {
                this.clearWeakReference();
            }
            return hasNext;
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            this.fut.cancel();
            this.clearWeakReference();
        }

        @Override
        protected void onRemove() throws IgniteCheckedException {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            this.convert.remove(this.cur);
            this.cur = null;
        }

        @Override
        public WeakReference<WeakQueryFutureIterator<T>> weakReference() {
            return this.weakRef;
        }

        private void clearWeakReference() {
            this.weakRef.clear();
            CacheWeakQueryIteratorsHolder.this.refs.remove(this.weakRef);
        }

        private void init() throws IgniteCheckedException {
            if (!this.init) {
                Object futNext = this.fut.next();
                this.next = futNext != null ? this.convert.convert(futNext) : null;
                this.init = true;
            }
        }
    }
}

