/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.jetbrains.annotations.Nullable;

public class CacheStoreBalancingWrapper<K, V>
implements CacheStore<K, V> {
    public static final int DFLT_LOAD_ALL_THRESHOLD = 5;
    private CacheStore<K, V> delegate;
    private ConcurrentMap<K, LoadFuture> pendingLoads = new ConcurrentHashMap<K, LoadFuture>();
    private int loadAllThreshold = 5;

    public CacheStoreBalancingWrapper(CacheStore<K, V> delegate) {
        this.delegate = delegate;
    }

    public CacheStoreBalancingWrapper(CacheStore<K, V> delegate, int loadAllThreshold) {
        this.delegate = delegate;
        this.loadAllThreshold = loadAllThreshold;
    }

    public int loadAllThreshold() {
        return this.loadAllThreshold;
    }

    @Override
    @Nullable
    public V load(K key) {
        LoadFuture fut = (LoadFuture)this.pendingLoads.get(key);
        try {
            if (fut != null) {
                return fut.get(key);
            }
            fut = new LoadFuture();
            LoadFuture old = this.pendingLoads.putIfAbsent(key, fut);
            if (old != null) {
                return old.get(key);
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
        try {
            Object val = this.delegate.load(key);
            fut.onComplete(key, val);
            return val;
        }
        catch (Throwable e) {
            fut.onError(key, e);
            if (e instanceof Error) {
                throw e;
            }
            throw e;
        }
    }

    @Override
    public void loadCache(IgniteBiInClosure<K, V> clo, Object ... args2) {
        this.delegate.loadCache(clo, args2);
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        assert (false);
        return this.delegate.loadAll(keys);
    }

    public void loadAll(Collection<? extends K> keys, IgniteBiInClosure<K, V> c) {
        assert (keys.size() <= this.loadAllThreshold) : this.loadAllThreshold;
        ArrayList<Object> needLoad = null;
        HashMap<Object, LoadFuture> pending = null;
        LoadFuture span2 = null;
        for (Object key : keys) {
            LoadFuture old;
            LoadFuture loadFuture = (LoadFuture)this.pendingLoads.get(key);
            if (loadFuture != null) {
                if (pending == null) {
                    pending = new HashMap<Object, LoadFuture>();
                }
                pending.put(key, loadFuture);
                continue;
            }
            if (span2 == null) {
                span2 = new LoadFuture();
            }
            if ((old = this.pendingLoads.putIfAbsent(key, span2)) != null) {
                if (pending == null) {
                    pending = new HashMap();
                }
                pending.put(key, old);
                continue;
            }
            if (needLoad == null) {
                needLoad = new ArrayList<Object>(keys.size());
            }
            needLoad.add(key);
        }
        if (needLoad != null) {
            assert (!needLoad.isEmpty());
            assert (span2 != null);
            try {
                Map loaded = this.delegate.loadAll(needLoad);
                if (loaded != null) {
                    for (Map.Entry entry2 : loaded.entrySet()) {
                        c.apply(entry2.getKey(), entry2.getValue());
                    }
                }
                span2.onComplete(needLoad, loaded);
            }
            catch (Throwable e) {
                span2.onError(needLoad, e);
                if (e instanceof Error) {
                    throw e;
                }
                throw e;
            }
        }
        if (pending != null) {
            try {
                for (Map.Entry e : pending.entrySet()) {
                    Object k = e.getKey();
                    c.apply(k, ((LoadFuture)e.getValue()).get(k));
                }
            }
            catch (IgniteCheckedException e) {
                throw new CacheLoaderException(e);
            }
        }
    }

    @Override
    public void write(Cache.Entry<? extends K, ? extends V> entry2) {
        this.delegate.write(entry2);
    }

    @Override
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        this.delegate.writeAll(entries);
    }

    @Override
    public void delete(Object key) throws CacheWriterException {
        this.delegate.delete(key);
    }

    @Override
    public void deleteAll(Collection<?> keys) throws CacheWriterException {
        this.delegate.deleteAll(keys);
    }

    @Override
    public void sessionEnd(boolean commit2) {
        this.delegate.sessionEnd(commit2);
    }

    public String toString() {
        return S.toString(CacheStoreBalancingWrapper.class, this);
    }

    private class LoadFuture
    extends GridFutureAdapter<Map<K, V>> {
        private volatile Collection<K> keys;

        @Override
        public boolean onDone(@Nullable Map<K, V> res, @Nullable Throwable err2) {
            if (super.onDone(res, err2)) {
                assert (this.keys != null);
                for (Object key : this.keys) {
                    CacheStoreBalancingWrapper.this.pendingLoads.remove(key, this);
                }
                return true;
            }
            return false;
        }

        public void onComplete(K key, V val) {
            this.onComplete(Collections.singletonList(key), F.asMap(key, val));
        }

        public void onComplete(Collection<K> keys, Map<K, V> res) {
            this.keys = keys;
            this.onDone(res);
        }

        public void onError(K key, Throwable err2) {
            this.keys = Collections.singletonList(key);
            this.onDone(err2);
        }

        public void onError(Collection<K> keys, Throwable err2) {
            this.keys = keys;
            this.onDone(err2);
        }

        public V get(K key) throws IgniteCheckedException {
            return ((Map)this.get()).get(key);
        }
    }
}

