/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEvictionManager;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheOffheapEvictionManager
extends GridCacheManagerAdapter
implements CacheEvictionManager {
    @Override
    public void touch(IgniteTxEntry txEntry, boolean loc) {
        this.touch(txEntry.cached(), null);
    }

    @Override
    public void touch(GridCacheEntryEx e, AffinityTopologyVersion topVer) {
        if (e.detached()) {
            return;
        }
        try {
            boolean evicted;
            boolean bl = evicted = e.evictInternal(GridCacheVersionManager.EVICT_VER, null, false) || e.markObsoleteIfEmpty(null);
            if (evicted && !e.isDht()) {
                this.cctx.cache().removeEntry(e);
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to evict entry from cache: " + e, ex);
        }
    }

    @Override
    public boolean evict(@Nullable GridCacheEntryEx entry2, @Nullable GridCacheVersion obsoleteVer, boolean explicit, @Nullable CacheEntryPredicate[] filter2) throws IgniteCheckedException {
        return false;
    }

    @Override
    public void batchEvict(Collection<?> keys, @Nullable GridCacheVersion obsoleteVer) {
    }
}

