/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.MutableSingletonList;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheObjectUtils {
    public static Object unwrapBinaryIfNeeded(CacheObjectValueContext ctx, CacheObject o, boolean keepBinary, boolean cpy) {
        return CacheObjectUtils.unwrapBinary(ctx, o, keepBinary, cpy);
    }

    public static Object unwrapBinaryIfNeeded(CacheObjectValueContext ctx, Object o, boolean keepBinary, boolean cpy) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map.Entry) {
            Map.Entry entry2 = (Map.Entry)o;
            Object key = entry2.getKey();
            Object uKey = CacheObjectUtils.unwrapBinary(ctx, key, keepBinary, cpy);
            Object val = entry2.getValue();
            Object uVal = CacheObjectUtils.unwrapBinary(ctx, val, keepBinary, cpy);
            return key != uKey || val != uVal ? F.t(uKey, uVal) : o;
        }
        return CacheObjectUtils.unwrapBinary(ctx, o, keepBinary, cpy);
    }

    public static Collection<Object> unwrapBinariesIfNeeded(CacheObjectValueContext ctx, Collection<Object> col, boolean keepBinary) {
        return CacheObjectUtils.unwrapBinariesIfNeeded(ctx, col, keepBinary, true);
    }

    private static Collection<Object> unwrapKnownCollection(CacheObjectValueContext ctx, Collection<Object> col, boolean keepBinary, boolean cpy) {
        Collection<Object> col0 = BinaryUtils.newKnownCollection(col);
        assert (col0 != null);
        for (Object obj : col) {
            col0.add(CacheObjectUtils.unwrapBinary(ctx, obj, keepBinary, cpy));
        }
        return col0 instanceof MutableSingletonList ? U.convertToSingletonList(col0) : col0;
    }

    private static Map<Object, Object> unwrapBinariesIfNeeded(CacheObjectValueContext ctx, Map<Object, Object> map2, boolean keepBinary, boolean cpy) {
        if (keepBinary) {
            return map2;
        }
        Map<Object, Object> map0 = BinaryUtils.newMap(map2);
        for (Map.Entry<Object, Object> e : map2.entrySet()) {
            map0.put(CacheObjectUtils.unwrapBinary(ctx, e.getKey(), false, cpy), CacheObjectUtils.unwrapBinary(ctx, e.getValue(), false, cpy));
        }
        return map0;
    }

    private static Collection<Object> unwrapBinariesIfNeeded(CacheObjectValueContext ctx, Collection<Object> col, boolean keepBinary, boolean cpy) {
        Collection<Object> col0 = BinaryUtils.newKnownCollection(col);
        if (col0 == null) {
            col0 = new ArrayList(col.size());
        }
        for (Object obj : col) {
            col0.add(CacheObjectUtils.unwrapBinaryIfNeeded(ctx, obj, keepBinary, cpy));
        }
        return col0;
    }

    private static Object[] unwrapBinariesInArrayIfNeeded(CacheObjectValueContext ctx, Object[] arr, boolean keepBinary, boolean cpy) {
        if (BinaryUtils.knownArray(arr)) {
            return arr;
        }
        Object[] res = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = CacheObjectUtils.unwrapBinary(ctx, arr[i], keepBinary, cpy);
        }
        return res;
    }

    private static Object unwrapBinary(CacheObjectValueContext ctx, Object o, boolean keepBinary, boolean cpy) {
        if (o == null) {
            return o;
        }
        while (BinaryUtils.knownCacheObject(o)) {
            CacheObject co = (CacheObject)o;
            if (!co.isPlatformType() && keepBinary) {
                return o;
            }
            o = co.value(ctx, cpy);
        }
        if (BinaryUtils.knownCollection(o)) {
            return CacheObjectUtils.unwrapKnownCollection(ctx, (Collection)o, keepBinary, cpy);
        }
        if (BinaryUtils.knownMap(o)) {
            return CacheObjectUtils.unwrapBinariesIfNeeded(ctx, (Map)o, keepBinary, cpy);
        }
        if (o instanceof Object[]) {
            return CacheObjectUtils.unwrapBinariesInArrayIfNeeded(ctx, (Object[])o, keepBinary, cpy);
        }
        return o;
    }

    private CacheObjectUtils() {
    }
}

