/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.internal.processors.cache.CacheEvictionManager;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheEvictableEntryImpl<K, V>
implements EvictableEntry<K, V> {
    private static final int META_KEY = GridMetadataAwareAdapter.EntryKey.CACHE_EVICTABLE_ENTRY_KEY.key();
    @GridToStringInclude
    protected GridCacheEntryEx cached;

    protected CacheEvictableEntryImpl(GridCacheEntryEx cached) {
        this.cached = cached;
    }

    @Override
    public K getKey() throws IllegalStateException {
        return (K)this.cached.key().value(this.cached.context().cacheObjectContext(), false);
    }

    @Override
    public boolean isCached() {
        return !this.cached.obsoleteOrDeleted();
    }

    @Override
    public boolean evict() {
        GridCacheContext ctx = this.cached.context();
        try {
            assert (ctx != null);
            CacheEvictionManager mgr = ctx.evicts();
            if (mgr == null) {
                assert (ctx.kernalContext().isStopping());
                return false;
            }
            return mgr.evict(this.cached, null, false, null);
        }
        catch (IgniteCheckedException e) {
            U.error(ctx.grid().log(), "Failed to evict entry from cache: " + this.cached, e);
            return false;
        }
    }

    @Nullable
    public V peek() {
        try {
            CacheObject val = this.cached.peek(null);
            return val != null ? (V)val.value(this.cached.context().cacheObjectContext(), false) : null;
        }
        catch (GridCacheEntryRemovedException ignored) {
            return null;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public int size() {
        try {
            GridCacheContext cctx = this.cached.context();
            KeyCacheObject key = this.cached.key();
            byte[] keyBytes = key.valueBytes(cctx.cacheObjectContext());
            byte[] valBytes = null;
            CacheObject cacheObj = this.cached.valueBytes();
            if (cacheObj != null) {
                valBytes = cacheObj.valueBytes(cctx.cacheObjectContext());
            }
            return valBytes == null ? keyBytes.length : keyBytes.length + valBytes.length;
        }
        catch (GridCacheEntryRemovedException ignored) {
            return 0;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public V getValue() {
        try {
            GridTuple<CacheObject> peek2;
            GridNearTxLocal tx = this.cached.context().tm().userTx();
            if (tx != null && (peek2 = tx.peek(this.cached.context(), false, this.cached.key())) != null) {
                return (V)peek2.get().value(this.cached.context().cacheObjectContext(), false);
            }
            if (this.cached.detached()) {
                CacheObject val = this.cached.rawGet();
                return val != null ? (V)val.value(this.cached.context().cacheObjectContext(), false) : null;
            }
            while (true) {
                GridCacheEntryEx e;
                if ((e = this.cached.context().cache().peekEx(this.cached.key())) == null) {
                    return null;
                }
                try {
                    CacheObject val = e.peek(null);
                    return val != null ? (V)val.value(this.cached.context().cacheObjectContext(), false) : null;
                }
                catch (GridCacheEntryRemovedException val) {
                    continue;
                }
                catch (IgniteCheckedException ex) {
                    throw new IgniteException(ex);
                }
                break;
            }
        }
        catch (GridCacheFilterFailedException ignored) {
            throw new IgniteException("Should never happen.");
        }
    }

    @Override
    @Nullable
    public <T> T addMeta(T val) {
        return this.cached.addMeta(META_KEY, val);
    }

    @Override
    @Nullable
    public <T> T meta() {
        return (T)this.cached.meta(META_KEY);
    }

    @Override
    @Nullable
    public <T> T removeMeta() {
        return (T)this.cached.removeMeta(META_KEY);
    }

    @Override
    public <T> boolean removeMeta(T val) {
        return this.cached.removeMeta(META_KEY, val);
    }

    @Override
    @Nullable
    public <T> T putMetaIfAbsent(T val) {
        return this.cached.putMetaIfAbsent(META_KEY, val);
    }

    @Override
    public <T> boolean replaceMeta(T curVal, T newVal) {
        return this.cached.replaceMeta(META_KEY, curVal, newVal);
    }

    @Override
    public <T> T unwrap(Class<T> clazz2) {
        if (clazz2.isAssignableFrom(IgniteCache.class)) {
            return (T)this.cached.context().grid().cache(this.cached.context().name());
        }
        if (clazz2.isAssignableFrom(this.getClass())) {
            return clazz2.cast(this);
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        return this.cached.key().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CacheEvictableEntryImpl) {
            CacheEvictableEntryImpl other = (CacheEvictableEntryImpl)obj;
            return this.cached.key().equals(other.cached.key());
        }
        return false;
    }

    public String toString() {
        return S.toString(CacheEvictableEntryImpl.class, this);
    }
}

