/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public abstract class CacheEntryPredicateAdapter
implements CacheEntryPredicate {
    private static final long serialVersionUID = 4647110502545358709L;
    protected transient boolean locked;

    @Override
    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
    }

    @Override
    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
    }

    @Override
    public void entryLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public short directType() {
        assert (false) : this;
        return 0;
    }

    @Override
    public byte fieldsCount() {
        return 0;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        return reader.afterMessageRead(CacheEntryPredicateAdapter.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        return true;
    }

    @Nullable
    protected CacheObject peekVisibleValue(GridCacheEntryEx entry2) {
        return this.locked ? entry2.rawGet() : entry2.peekVisibleValue();
    }

    @Override
    public void onAckReceived() {
    }
}

