/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload.pipeline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.bulkload.pipeline.PipelineBlock;

public class LineSplitterBlock
extends PipelineBlock<char[], String> {
    private final Pattern delim;
    private StringBuilder leftover = new StringBuilder();

    public LineSplitterBlock(Pattern delim) {
        this.delim = delim;
    }

    @Override
    public void accept(char[] chars, boolean isLastPortion) throws IgniteCheckedException {
        this.leftover.append(chars);
        String input2 = this.leftover.toString();
        Matcher matcher2 = this.delim.matcher(input2);
        int lastPos = 0;
        while (matcher2.find()) {
            String outStr = input2.substring(lastPos, matcher2.start());
            if (!outStr.isEmpty()) {
                this.nextBlock.accept(outStr, false);
            }
            lastPos = matcher2.end();
        }
        if (lastPos != 0) {
            this.leftover.delete(0, lastPos);
        }
        if (isLastPortion && this.leftover.length() > 0) {
            this.nextBlock.accept(this.leftover.toString(), true);
            this.leftover.setLength(0);
        }
    }
}

