/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCacheWriter;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParser;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.lang.IgniteBiTuple;

public class BulkLoadProcessor
implements AutoCloseable {
    private final BulkLoadParser inputParser;
    private final IgniteClosureX<List<?>, IgniteBiTuple<?, ?>> dataConverter;
    private final BulkLoadCacheWriter outputStreamer;
    private boolean isClosed;

    public BulkLoadProcessor(BulkLoadParser inputParser, IgniteClosureX<List<?>, IgniteBiTuple<?, ?>> dataConverter, BulkLoadCacheWriter outputStreamer) {
        this.inputParser = inputParser;
        this.dataConverter = dataConverter;
        this.outputStreamer = outputStreamer;
        this.isClosed = false;
    }

    public BulkLoadCacheWriter outputStreamer() {
        return this.outputStreamer;
    }

    public void processBatch(byte[] batchData, boolean isLastBatch) throws IgniteCheckedException {
        if (this.isClosed) {
            throw new IgniteIllegalStateException("Attempt to process a batch on a closed BulkLoadProcessor");
        }
        Iterable<List<Object>> inputRecords = this.inputParser.parseBatch(batchData, isLastBatch);
        for (List<Object> record2 : inputRecords) {
            IgniteBiTuple<?, ?> kv = this.dataConverter.apply(record2);
            this.outputStreamer.apply(kv);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.outputStreamer.close();
    }
}

