/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParser;
import org.apache.ignite.internal.processors.bulkload.pipeline.CharsetDecoderBlock;
import org.apache.ignite.internal.processors.bulkload.pipeline.CsvLineProcessorBlock;
import org.apache.ignite.internal.processors.bulkload.pipeline.LineSplitterBlock;
import org.apache.ignite.internal.processors.bulkload.pipeline.PipelineBlock;
import org.apache.ignite.internal.processors.bulkload.pipeline.StrListAppenderBlock;
import org.apache.ignite.internal.processors.query.IgniteSQLException;

public class BulkLoadCsvParser
extends BulkLoadParser {
    private final PipelineBlock<byte[], char[]> inputBlock;
    private final StrListAppenderBlock collectorBlock;

    public BulkLoadCsvParser(BulkLoadCsvFormat format2) {
        try {
            Charset charset = format2.inputCharsetName() == null ? BulkLoadFormat.DEFAULT_INPUT_CHARSET : Charset.forName(format2.inputCharsetName());
            this.inputBlock = new CharsetDecoderBlock(charset);
        }
        catch (IllegalCharsetNameException e) {
            throw new IgniteSQLException("Unknown charset name: '" + format2.inputCharsetName() + "': " + e.getMessage());
        }
        catch (UnsupportedCharsetException e) {
            throw new IgniteSQLException("Charset is not supported: '" + format2.inputCharsetName() + "': " + e.getMessage());
        }
        this.collectorBlock = new StrListAppenderBlock();
        this.inputBlock.append(new LineSplitterBlock(format2.lineSeparator())).append(new CsvLineProcessorBlock(format2.fieldSeparator(), format2.quoteChars())).append(this.collectorBlock);
    }

    @Override
    protected Iterable<List<Object>> parseBatch(byte[] batchData, boolean isLastBatch) throws IgniteCheckedException {
        LinkedList<List<Object>> res = new LinkedList<List<Object>>();
        this.collectorBlock.output(res);
        this.inputBlock.accept(batchData, isLastBatch);
        return res;
    }
}

