/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload;

import org.jetbrains.annotations.NotNull;

public class BulkLoadAckClientParameters {
    public static final int MIN_PACKET_SIZE = 1;
    public static final int MAX_PACKET_SIZE = 0x7FFFFDFF;
    public static final int DFLT_PACKET_SIZE = 0x400000;
    @NotNull
    private final String locFileName;
    private final int packetSize;

    public BulkLoadAckClientParameters(@NotNull String locFileName, int packetSize) {
        this.locFileName = locFileName;
        this.packetSize = packetSize;
    }

    @NotNull
    public String localFileName() {
        return this.locFileName;
    }

    public int packetSize() {
        return this.packetSize;
    }

    public static boolean isValidPacketSize(int sz) {
        return sz >= 1 && sz <= 0x7FFFFDFF;
    }

    public static String packetSizeErrorMesssage(int size2) {
        return "Packet size should be within [1..2147483135]: " + size2;
    }
}

