/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.authentication;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.mindrot.BCrypt;

public class User
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String DFAULT_USER_NAME = "ignite";
    private static final String DFLT_USER_PASSWORD = "ignite";
    private String name;
    @GridToStringExclude
    private String hashedPasswd;

    public User() {
    }

    private User(String name, String hashedPasswd) {
        this.name = name;
        this.hashedPasswd = hashedPasswd;
    }

    public String name() {
        return this.name;
    }

    public static User create(String name, String passwd) {
        return new User(name, User.password(passwd));
    }

    public static User create(String name) {
        return new User(name, null);
    }

    public static User defaultUser() {
        return User.create("ignite", "ignite");
    }

    @Nullable
    public static String password(String passwd) {
        return User.password_bcrypt(passwd);
    }

    @Nullable
    private static String password_bcrypt(String passwd) {
        return BCrypt.hashpw(passwd, BCrypt.gensalt());
    }

    public boolean authorize(String passwd) {
        if (F.isEmpty(passwd)) {
            return this.hashedPasswd == null;
        }
        return BCrypt.checkpw(passwd, this.hashedPasswd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User u = (User)o;
        return F.eq(this.name, u.name) && F.eq(this.hashedPasswd, u.hashedPasswd);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.name, this.hashedPasswd);
        return result2;
    }

    public String toString() {
        return S.toString(User.class, this);
    }
}

