/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignment;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class HistoryAffinityAssignment
implements AffinityAssignment {
    private final AffinityTopologyVersion topVer;
    private final List<List<ClusterNode>> assignment;
    private final List<List<ClusterNode>> idealAssignment;
    private final MvccCoordinator mvccCrd;

    HistoryAffinityAssignment(GridAffinityAssignment assign) {
        this.topVer = assign.topologyVersion();
        this.assignment = assign.assignment();
        this.idealAssignment = assign.idealAssignment();
        this.mvccCrd = assign.mvccCoordinator();
    }

    @Override
    public MvccCoordinator mvccCoordinator() {
        return this.mvccCrd;
    }

    @Override
    public List<List<ClusterNode>> idealAssignment() {
        return this.idealAssignment;
    }

    @Override
    public List<List<ClusterNode>> assignment() {
        return this.assignment;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public List<ClusterNode> get(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + ']';
        return this.assignment.get(part);
    }

    @Override
    public HashSet<UUID> getIds(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + ']';
        List<ClusterNode> nodes2 = this.assignment.get(part);
        HashSet<UUID> ids = U.newHashSet(nodes2.size());
        for (int i = 0; i < nodes2.size(); ++i) {
            ids.add(nodes2.get(i).id());
        }
        return ids;
    }

    @Override
    public Set<ClusterNode> nodes() {
        HashSet<ClusterNode> res = new HashSet<ClusterNode>();
        for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes2 = this.assignment.get(p);
            if (F.isEmpty(nodes2)) continue;
            res.addAll(nodes2);
        }
        return res;
    }

    @Override
    public Set<ClusterNode> primaryPartitionNodes() {
        HashSet<ClusterNode> res = new HashSet<ClusterNode>();
        for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes2 = this.assignment.get(p);
            if (F.isEmpty(nodes2)) continue;
            res.add(nodes2.get(0));
        }
        return res;
    }

    @Override
    public Set<Integer> primaryPartitions(UUID nodeId) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes2 = this.assignment.get(p);
            if (F.isEmpty(nodes2) || !nodes2.get(0).id().equals(nodeId)) continue;
            res.add(p);
        }
        return res;
    }

    @Override
    public Set<Integer> backupPartitions(UUID nodeId) {
        HashSet<Integer> res = new HashSet<Integer>();
        block0: for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes2 = this.assignment.get(p);
            for (int i = 1; i < nodes2.size(); ++i) {
                ClusterNode node = nodes2.get(i);
                if (!node.id().equals(nodeId)) continue;
                res.add(p);
                continue block0;
            }
        }
        return res;
    }

    public int hashCode() {
        return this.topVer.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AffinityAssignment)) {
            return false;
        }
        return this.topVer.equals(((AffinityAssignment)o).topologyVersion());
    }

    public String toString() {
        return S.toString(HistoryAffinityAssignment.class, this);
    }
}

