/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityCentralizedFunction;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignment;
import org.apache.ignite.internal.processors.affinity.GridAffinityFunctionContextImpl;
import org.apache.ignite.internal.processors.affinity.HistoryAffinityAssignment;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridAffinityAssignmentCache {
    private final int MAX_HIST_SIZE = IgniteSystemProperties.getInteger("IGNITE_AFFINITY_HISTORY_SIZE", 500);
    private final float partDistribution = IgniteSystemProperties.getFloat("IGNITE_PART_DISTRIBUTION_WARN_THRESHOLD", 50.0f);
    private final String cacheOrGrpName;
    private final int grpId;
    private final int backups;
    private final AffinityFunction aff;
    private final IgnitePredicate<ClusterNode> nodeFilter;
    private final int partsCnt;
    private final ConcurrentNavigableMap<AffinityTopologyVersion, HistoryAffinityAssignment> affCache;
    private List<List<ClusterNode>> idealAssignment;
    private BaselineTopology baselineTopology;
    private List<List<ClusterNode>> baselineAssignment;
    private final AtomicReference<GridAffinityAssignment> head;
    private final ConcurrentMap<AffinityTopologyVersion, AffinityReadyFuture> readyFuts = new ConcurrentSkipListMap<AffinityTopologyVersion, AffinityReadyFuture>();
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private final boolean locCache;
    private final boolean persistentCache;
    private volatile IgniteCheckedException stopErr;
    private final AtomicInteger fullHistSize = new AtomicInteger();
    private final Object similarAffKey;

    public GridAffinityAssignmentCache(GridKernalContext ctx, String cacheOrGrpName, int grpId, AffinityFunction aff, IgnitePredicate<ClusterNode> nodeFilter, int backups, boolean locCache, boolean persistentCache) {
        assert (ctx != null);
        assert (aff != null);
        assert (nodeFilter != null);
        assert (grpId != 0);
        this.ctx = ctx;
        this.aff = aff;
        this.nodeFilter = nodeFilter;
        this.cacheOrGrpName = cacheOrGrpName;
        this.grpId = grpId;
        this.backups = backups;
        this.locCache = locCache;
        this.persistentCache = persistentCache;
        this.log = ctx.log(GridAffinityAssignmentCache.class);
        this.partsCnt = aff.partitions();
        this.affCache = new ConcurrentSkipListMap<AffinityTopologyVersion, HistoryAffinityAssignment>();
        this.head = new AtomicReference<GridAffinityAssignment>(new GridAffinityAssignment(AffinityTopologyVersion.NONE));
        this.similarAffKey = ctx.affinity().similaryAffinityKey(aff, nodeFilter, backups, this.partsCnt);
        assert (this.similarAffKey != null);
    }

    public Object similarAffinityKey() {
        return this.similarAffKey;
    }

    public String cacheOrGroupName() {
        return this.cacheOrGrpName;
    }

    public int groupId() {
        return this.grpId;
    }

    public void initialize(AffinityTopologyVersion topVer, List<List<ClusterNode>> affAssignment) {
        MvccCoordinator mvccCrd = null;
        if (!this.locCache) {
            mvccCrd = this.ctx.cache().context().coordinators().currentCoordinator(topVer);
        }
        this.initialize(topVer, affAssignment, mvccCrd);
    }

    public void initialize(AffinityTopologyVersion topVer, List<List<ClusterNode>> affAssignment, MvccCoordinator mvccCrd) {
        assert (topVer.compareTo(this.lastVersion()) >= 0) : "[topVer = " + topVer + ", last=" + this.lastVersion() + ']';
        assert (this.idealAssignment != null);
        assert (mvccCrd == null || topVer.compareTo(mvccCrd.topologyVersion()) >= 0) : "[mvccCrd=" + mvccCrd + ", topVer=" + topVer + ']';
        GridAffinityAssignment assignment = new GridAffinityAssignment(topVer, affAssignment, this.idealAssignment, mvccCrd);
        HistoryAffinityAssignment hAff = this.affCache.put(topVer, new HistoryAffinityAssignment(assignment));
        this.head.set(assignment);
        for (Map.Entry entry2 : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry2.getKey()).compareTo(topVer) > 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future (initialized affinity) [locNodeId=" + this.ctx.localNodeId() + ", futVer=" + entry2.getKey() + ", topVer=" + topVer + ']');
            }
            ((AffinityReadyFuture)entry2.getValue()).onDone(topVer);
        }
        if (hAff == null) {
            this.onHistoryAdded();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("New affinity assignment [grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", aff=" + GridAffinityAssignmentCache.fold(affAssignment) + "]");
        }
    }

    public void idealAssignment(List<List<ClusterNode>> assignment) {
        this.idealAssignment = assignment;
    }

    @Nullable
    public List<List<ClusterNode>> idealAssignment() {
        return this.idealAssignment;
    }

    public boolean centralizedAffinityFunction() {
        return U.hasAnnotation(this.aff, AffinityCentralizedFunction.class);
    }

    public void cancelFutures(IgniteCheckedException err2) {
        this.stopErr = err2;
        for (AffinityReadyFuture fut : this.readyFuts.values()) {
            fut.onDone(err2);
        }
    }

    public void onReconnected() {
        this.idealAssignment = null;
        this.affCache.clear();
        this.fullHistSize.set(0);
        this.head.set(new GridAffinityAssignment(AffinityTopologyVersion.NONE));
        this.stopErr = null;
    }

    public List<List<ClusterNode>> calculate(AffinityTopologyVersion topVer, @Nullable ExchangeDiscoveryEvents events2, @Nullable DiscoCache discoCache) {
        List<List<ClusterNode>> assignment;
        List<ClusterNode> sorted2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Calculating affinity [topVer=" + topVer + ", locNodeId=" + this.ctx.localNodeId() + ", discoEvts=" + events2 + ']');
        }
        List<List<ClusterNode>> prevAssignment = this.idealAssignment;
        if (!this.locCache) {
            sorted2 = new ArrayList<ClusterNode>(discoCache.cacheGroupAffinityNodes(this.groupId()));
            Collections.sort(sorted2, NodeOrderComparator.getInstance());
        } else {
            sorted2 = Collections.singletonList(this.ctx.discovery().localNode());
        }
        boolean hasBaseline = false;
        boolean changedBaseline = false;
        if (discoCache != null) {
            boolean bl = hasBaseline = discoCache.state().baselineTopology() != null && this.persistentCache;
            boolean bl2 = !hasBaseline ? this.baselineTopology != null : (changedBaseline = !discoCache.state().baselineTopology().equals(this.baselineTopology));
        }
        if (prevAssignment != null && events2 != null) {
            boolean skipCalculation = true;
            for (DiscoveryEvent event : events2.events()) {
                boolean affinityNode = CU.affinityNode(event.eventNode(), this.nodeFilter);
                if (!affinityNode && event.type() != 18) continue;
                skipCalculation = false;
                break;
            }
            if (skipCalculation) {
                assignment = prevAssignment;
            } else if (hasBaseline && !changedBaseline) {
                if (this.baselineAssignment == null) {
                    this.baselineAssignment = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(discoCache.state().baselineTopology().createBaselineView(sorted2, this.nodeFilter), prevAssignment, events2.lastEvent(), topVer, this.backups));
                }
                assignment = this.currentBaselineAssignment(topVer);
            } else if (hasBaseline && changedBaseline) {
                this.baselineAssignment = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(discoCache.state().baselineTopology().createBaselineView(sorted2, this.nodeFilter), prevAssignment, events2.lastEvent(), topVer, this.backups));
                assignment = this.currentBaselineAssignment(topVer);
            } else {
                assignment = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(sorted2, prevAssignment, events2.lastEvent(), topVer, this.backups));
            }
        } else {
            DiscoveryEvent event = null;
            if (events2 != null) {
                event = events2.lastEvent();
            }
            if (hasBaseline) {
                this.baselineAssignment = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(discoCache.state().baselineTopology().createBaselineView(sorted2, this.nodeFilter), prevAssignment, event, topVer, this.backups));
                assignment = this.currentBaselineAssignment(topVer);
            } else {
                assignment = this.aff.assignPartitions(new GridAffinityFunctionContextImpl(sorted2, prevAssignment, event, topVer, this.backups));
            }
        }
        assert (assignment != null);
        this.idealAssignment = assignment;
        if (this.ctx.cache().cacheMode(this.cacheOrGrpName) == CacheMode.PARTITIONED && !this.ctx.clientNode()) {
            this.printDistributionIfThresholdExceeded(assignment, sorted2.size());
        }
        if (hasBaseline) {
            this.baselineTopology = discoCache.state().baselineTopology();
            assert (this.baselineAssignment != null);
        } else {
            this.baselineTopology = null;
            this.baselineAssignment = null;
        }
        if (this.locCache) {
            this.initialize(topVer, assignment);
        }
        return assignment;
    }

    private List<List<ClusterNode>> currentBaselineAssignment(AffinityTopologyVersion topVer) {
        HashMap<Object, ClusterNode> alives = new HashMap<Object, ClusterNode>();
        for (ClusterNode node : this.ctx.discovery().nodes(topVer)) {
            if (node.isClient() || node.isDaemon()) continue;
            alives.put(node.consistentId(), node);
        }
        ArrayList<List<ClusterNode>> result2 = new ArrayList<List<ClusterNode>>(this.baselineAssignment.size());
        for (int p = 0; p < this.baselineAssignment.size(); ++p) {
            List<ClusterNode> baselineMapping = this.baselineAssignment.get(p);
            List currentMapping = null;
            for (ClusterNode node : baselineMapping) {
                ClusterNode aliveNode = (ClusterNode)alives.get(node.consistentId());
                if (aliveNode == null) continue;
                if (currentMapping == null) {
                    currentMapping = new ArrayList();
                }
                currentMapping.add(aliveNode);
            }
            result2.add(p, currentMapping != null ? currentMapping : Collections.emptyList());
        }
        return result2;
    }

    private void printDistributionIfThresholdExceeded(List<List<ClusterNode>> assignments, int nodes2) {
        int locPrimaryCnt = 0;
        int locBackupCnt = 0;
        for (List<ClusterNode> assignment : assignments) {
            for (int i = 0; i < assignment.size(); ++i) {
                ClusterNode node = assignment.get(i);
                if (!node.isLocal()) continue;
                if (i == 0) {
                    ++locPrimaryCnt;
                    continue;
                }
                ++locBackupCnt;
            }
        }
        float expCnt = (float)this.partsCnt / (float)nodes2;
        float deltaPrimary = Math.abs(1.0f - (float)locPrimaryCnt / expCnt) * 100.0f;
        float deltaBackup = Math.abs(1.0f - (float)locBackupCnt / (expCnt * (float)this.backups)) * 100.0f;
        if (deltaPrimary > this.partDistribution || deltaBackup > this.partDistribution) {
            this.log.info(String.format("Local node affinity assignment distribution is not ideal [cache=%s, expectedPrimary=%.2f, actualPrimary=%d, expectedBackups=%.2f, actualBackups=%d, warningThreshold=%.2f%%]", this.cacheOrGrpName, Float.valueOf(expCnt), locPrimaryCnt, Float.valueOf(expCnt * (float)this.backups), locBackupCnt, Float.valueOf(this.partDistribution)));
        }
    }

    public void clientEventTopologyChange(DiscoveryEvent evt, AffinityTopologyVersion topVer) {
        assert (topVer.compareTo(this.lastVersion()) >= 0) : "[topVer = " + topVer + ", last=" + this.lastVersion() + ']';
        GridAffinityAssignment aff = this.head.get();
        assert (evt.type() == 18 || aff.primaryPartitions(evt.eventNode().id()).isEmpty()) : evt;
        assert (evt.type() == 18 || aff.backupPartitions(evt.eventNode().id()).isEmpty()) : evt;
        GridAffinityAssignment assignmentCpy = new GridAffinityAssignment(topVer, aff);
        HistoryAffinityAssignment hAff = this.affCache.put(topVer, new HistoryAffinityAssignment(assignmentCpy));
        this.head.set(assignmentCpy);
        for (Map.Entry entry2 : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry2.getKey()).compareTo(topVer) > 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future (use previous affinity) [locNodeId=" + this.ctx.localNodeId() + ", futVer=" + entry2.getKey() + ", topVer=" + topVer + ']');
            }
            ((AffinityReadyFuture)entry2.getValue()).onDone(topVer);
        }
        if (hAff == null) {
            this.onHistoryAdded();
        }
    }

    public AffinityTopologyVersion lastVersion() {
        return this.head.get().topologyVersion();
    }

    public List<List<ClusterNode>> assignments(AffinityTopologyVersion topVer) {
        AffinityAssignment aff = this.cachedAffinity(topVer);
        return aff.assignment();
    }

    public List<List<ClusterNode>> readyAssignments(AffinityTopologyVersion topVer) {
        AffinityAssignment aff = this.readyAffinity(topVer);
        assert (aff != null) : "No ready affinity [grp=" + this.cacheOrGrpName + ", ver=" + topVer + ']';
        return aff.assignment();
    }

    @Nullable
    public IgniteInternalFuture<AffinityTopologyVersion> readyFuture(AffinityTopologyVersion topVer) {
        GridAffinityAssignment aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Returning finished future for readyFuture [head=" + aff.topologyVersion() + ", topVer=" + topVer + ']');
            }
            return null;
        }
        GridFutureAdapter fut = F.addIfAbsent(this.readyFuts, topVer, new AffinityReadyFuture(topVer));
        aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future right away [head=" + aff.topologyVersion() + ", topVer=" + topVer + ']');
            }
            fut.onDone(aff.topologyVersion());
        } else if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    public int partitions() {
        return this.partsCnt;
    }

    public List<ClusterNode> nodes(int part, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).get(part);
    }

    public Set<Integer> primaryPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).primaryPartitions(nodeId);
    }

    public Set<Integer> backupPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).backupPartitions(nodeId);
    }

    public boolean dumpDebugInfo() {
        if (!this.readyFuts.isEmpty()) {
            U.warn(this.log, "First 3 pending affinity ready futures [grp=" + this.cacheOrGrpName + ", total=" + this.readyFuts.size() + ", lastVer=" + this.lastVersion() + "]:");
            int cnt = 0;
            for (AffinityReadyFuture fut : this.readyFuts.values()) {
                U.warn(this.log, ">>> " + fut);
                if (++cnt != 3) continue;
                break;
            }
            return true;
        }
        return false;
    }

    public AffinityAssignment readyAffinity(AffinityTopologyVersion topVer) {
        AffinityAssignment cache = this.head.get();
        if (!cache.topologyVersion().equals(topVer) && (cache = (AffinityAssignment)this.affCache.get(topVer)) == null) {
            throw new IllegalStateException("Affinity for topology version is not initialized [locNode=" + this.ctx.discovery().localNode().id() + ", grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", head=" + this.head.get().topologyVersion() + ", history=" + this.affCache.keySet() + ']');
        }
        return cache;
    }

    public AffinityAssignment cachedAffinity(AffinityTopologyVersion topVer) {
        if (topVer.equals(AffinityTopologyVersion.NONE)) {
            topVer = this.lastVersion();
        } else {
            this.awaitTopologyVersion(topVer);
        }
        assert (topVer.topologyVersion() >= 0L) : topVer;
        AffinityAssignment cache = this.head.get();
        if (!cache.topologyVersion().equals(topVer) && (cache = (AffinityAssignment)this.affCache.get(topVer)) == null) {
            throw new IllegalStateException("Getting affinity for topology version earlier than affinity is calculated [locNode=" + this.ctx.discovery().localNode() + ", grp=" + this.cacheOrGrpName + ", topVer=" + topVer + ", head=" + this.head.get().topologyVersion() + ", history=" + this.affCache.keySet() + ']');
        }
        assert (cache.topologyVersion().equals(topVer)) : "Invalid cached affinity: " + cache;
        return cache;
    }

    public boolean primaryChanged(int part, AffinityTopologyVersion startVer, AffinityTopologyVersion endVer) {
        AffinityAssignment aff = (AffinityAssignment)this.affCache.get(startVer);
        if (aff == null) {
            return false;
        }
        List<ClusterNode> nodes2 = aff.get(part);
        if (nodes2.isEmpty()) {
            return true;
        }
        ClusterNode primary = nodes2.get(0);
        for (AffinityAssignment assignment : this.affCache.tailMap((Object)startVer, false).values()) {
            List<ClusterNode> nodes0 = assignment.assignment().get(part);
            if (nodes0.isEmpty()) {
                return true;
            }
            if (!nodes0.get(0).equals(primary)) {
                return true;
            }
            if (!assignment.topologyVersion().equals(endVer)) continue;
            return false;
        }
        return true;
    }

    public void init(GridAffinityAssignmentCache aff) {
        assert (aff.lastVersion().compareTo(this.lastVersion()) >= 0);
        assert (aff.idealAssignment() != null);
        this.idealAssignment(aff.idealAssignment());
        AffinityAssignment assign = aff.cachedAffinity(aff.lastVersion());
        this.initialize(aff.lastVersion(), assign.assignment(), assign.mvccCoordinator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitTopologyVersion(AffinityTopologyVersion topVer) {
        block7: {
            GridAffinityAssignment aff = this.head.get();
            if (aff.topologyVersion().compareTo(topVer) >= 0) {
                return;
            }
            try {
                IgniteInternalFuture<AffinityTopologyVersion> fut;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Will wait for topology version [locNodeId=" + this.ctx.localNodeId() + ", topVer=" + topVer + ']');
                }
                if ((fut = this.readyFuture(topVer)) == null) break block7;
                Thread curTh = Thread.currentThread();
                String threadName = curTh.getName();
                try {
                    curTh.setName(threadName + " (waiting " + topVer + ")");
                    fut.get();
                }
                finally {
                    curTh.setName(threadName);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to wait for affinity ready future for topology version: " + topVer, e);
            }
        }
    }

    private void onHistoryAdded() {
        if (this.fullHistSize.incrementAndGet() > this.MAX_HIST_SIZE) {
            Iterator it = this.affCache.values().iterator();
            AffinityTopologyVersion topVerRmv = null;
            for (int rmvCnt = this.MAX_HIST_SIZE / 2; it.hasNext() && rmvCnt > 0; --rmvCnt) {
                AffinityAssignment aff0 = (AffinityAssignment)it.next();
                it.remove();
                this.fullHistSize.decrementAndGet();
                topVerRmv = aff0.topologyVersion();
            }
            topVerRmv = it.hasNext() ? ((HistoryAffinityAssignment)it.next()).topologyVersion() : topVerRmv;
            this.ctx.affinity().removeCachedAffinity(topVerRmv);
        }
    }

    public Collection<AffinityTopologyVersion> cachedVersions() {
        return this.affCache.keySet();
    }

    private static String fold(List<List<ClusterNode>> affAssignment) {
        SB sb = new SB();
        for (int p = 0; p < affAssignment.size(); ++p) {
            sb.a("Part [");
            sb.a("id=" + p + ", ");
            SB partOwners = new SB();
            List<ClusterNode> affOwners = affAssignment.get(p);
            for (ClusterNode node : affOwners) {
                partOwners.a(node.consistentId());
                partOwners.a(' ');
            }
            sb.a("owners=[");
            sb.a(partOwners);
            sb.a(']');
            sb.a("] ");
        }
        return sb.toString();
    }

    private class AffinityReadyFuture
    extends GridFutureAdapter<AffinityTopologyVersion> {
        private AffinityTopologyVersion reqTopVer;

        private AffinityReadyFuture(AffinityTopologyVersion reqTopVer) {
            this.reqTopVer = reqTopVer;
        }

        @Override
        public boolean onDone(AffinityTopologyVersion res, @Nullable Throwable err2) {
            assert (res != null || err2 != null);
            boolean done = super.onDone(res, err2);
            if (done) {
                GridAffinityAssignmentCache.this.readyFuts.remove(this.reqTopVer, this);
            }
            return done;
        }

        @Override
        public String toString() {
            return S.toString(AffinityReadyFuture.class, this);
        }
    }
}

