/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;

public class PageSnapshot
extends WALRecord
implements WalRecordCacheGroupAware {
    @GridToStringExclude
    private byte[] pageData;
    private FullPageId fullPageId;
    private int realPageSize;

    public PageSnapshot(FullPageId fullId, byte[] arr, int realPageSize) {
        this.fullPageId = fullId;
        this.pageData = arr;
        this.realPageSize = realPageSize;
    }

    public PageSnapshot(FullPageId fullPageId, long ptr, int pageSize, int realPageSize) {
        this.fullPageId = fullPageId;
        this.realPageSize = realPageSize;
        this.pageData = new byte[pageSize];
        GridUnsafe.copyMemory(null, ptr, this.pageData, GridUnsafe.BYTE_ARR_OFF, pageSize);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGE_RECORD;
    }

    public byte[] pageData() {
        return this.pageData;
    }

    public FullPageId fullPageId() {
        return this.fullPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ByteBuffer buf = ByteBuffer.allocateDirect(this.pageData.length);
        buf.order(ByteOrder.nativeOrder());
        buf.put(this.pageData);
        long addr = GridUnsafe.bufferAddress(buf);
        try {
            String string2 = "PageSnapshot [fullPageId = " + this.fullPageId() + ", page = [\n" + PageIO.printPage(addr, this.realPageSize) + "],\nsuper = [" + super.toString() + "]]";
            return string2;
        }
        finally {
            GridUnsafe.cleanDirectBuffer(buf);
        }
    }

    @Override
    public int groupId() {
        return this.fullPageId.groupId();
    }
}

