/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem;

import org.apache.ignite.internal.util.GridUnsafe;

public class PageUtils {
    public static byte getByte(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getByte(addr + (long)off);
    }

    public static int getUnsignedByte(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getByte(addr + (long)off) & 0xFF;
    }

    public static byte[] getBytes(long addr, int off, int len) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (len >= 0);
        byte[] bytes2 = new byte[len];
        GridUnsafe.copyMemory(null, addr + (long)off, bytes2, GridUnsafe.BYTE_ARR_OFF, len);
        return bytes2;
    }

    public static void getBytes(long srcAddr, int srcOff, byte[] dst, int dstOff, int len) {
        assert (srcAddr > 0L);
        assert (srcOff > 0);
        assert (dst != null);
        assert (dstOff >= 0);
        assert (len >= 0);
        GridUnsafe.copyMemory(null, srcAddr + (long)srcOff, dst, GridUnsafe.BYTE_ARR_OFF + (long)dstOff, len);
    }

    public static short getShort(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getShort(addr + (long)off);
    }

    public static int getInt(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getInt(addr + (long)off);
    }

    public static long getLong(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getLong(addr + (long)off);
    }

    public static void putBytes(long addr, int off, byte[] bytes2) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (bytes2 != null);
        GridUnsafe.copyMemory(bytes2, GridUnsafe.BYTE_ARR_OFF, null, addr + (long)off, bytes2.length);
    }

    public static void putBytes(long addr, int off, byte[] bytes2, int bytesOff) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (bytes2 != null);
        assert (bytesOff >= 0 && (bytesOff < bytes2.length || bytes2.length == 0)) : bytesOff;
        GridUnsafe.copyMemory(bytes2, GridUnsafe.BYTE_ARR_OFF + (long)bytesOff, null, addr + (long)off, bytes2.length - bytesOff);
    }

    public static void putBytes(long addr, int off, byte[] bytes2, int bytesOff, int len) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (bytes2 != null);
        assert (bytesOff >= 0 && (bytesOff < bytes2.length || bytes2.length == 0)) : bytesOff;
        GridUnsafe.copyMemory(bytes2, GridUnsafe.BYTE_ARR_OFF + (long)bytesOff, null, addr + (long)off, len);
    }

    public static void putByte(long addr, int off, byte v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putByte(addr + (long)off, v);
    }

    public static void putUnsignedByte(long addr, int off, int v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (v >= 0 && v <= 255);
        GridUnsafe.putByte(addr + (long)off, (byte)v);
    }

    public static void putShort(long addr, int off, short v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putShort(addr + (long)off, v);
    }

    public static void putInt(long addr, int off, int v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putInt(addr + (long)off, v);
    }

    public static void putLong(long addr, int off, long v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putLong(addr + (long)off, v);
    }
}

