/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

public class IgniteStandardMXBean
extends StandardMBean {
    private static final Map<String, Class<?>> primCls = new HashMap();

    public <T> IgniteStandardMXBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info2) {
        String str = super.getDescription(info2);
        String methodName = (info2.isIs() ? "is" : "get") + info2.getName();
        try {
            MXBeanDescription desc;
            Method mtd = this.findMethod(this.getMBeanInterface(), methodName, new Class[0]);
            if (mtd != null && (desc = mtd.getAnnotation(MXBeanDescription.class)) != null) {
                str = desc.value();
                assert (str != null) : "Failed to find method: " + mtd;
                assert (!str.trim().isEmpty()) : "Method description cannot be empty: " + mtd;
                assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
                assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanInfo info2) {
        String str = super.getDescription(info2);
        MXBeanDescription desc = U.getAnnotation(this.getMBeanInterface(), MXBeanDescription.class);
        if (desc != null) {
            str = desc.value();
            assert (str != null);
            assert (!str.trim().isEmpty());
            assert (Character.isUpperCase(str.charAt(0))) : str;
            assert (str.charAt(str.length() - 1) == '.') : str;
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info2) {
        String str = super.getDescription(info2);
        try {
            Method m = this.getMethod(info2);
            MXBeanDescription desc = m.getAnnotation(MXBeanDescription.class);
            if (desc != null) {
                str = desc.value();
                assert (str != null);
                assert (!str.trim().isEmpty());
                assert (Character.isUpperCase(str.charAt(0))) : str;
                assert (str.charAt(str.length() - 1) == '.') : str;
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param2, int seq) {
        String str = super.getDescription(op, param2, seq);
        try {
            Method m = this.getMethod(op);
            MXBeanParametersDescriptions decsAnn = m.getAnnotation(MXBeanParametersDescriptions.class);
            if (decsAnn != null) {
                assert (decsAnn.value() != null);
                assert (seq < decsAnn.value().length);
                str = decsAnn.value()[seq];
                assert (str != null);
                assert (!str.trim().isEmpty());
                assert (Character.isUpperCase(str.charAt(0))) : str;
                assert (str.charAt(str.length() - 1) == '.') : str;
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param2, int seq) {
        String str = super.getParameterName(op, param2, seq);
        try {
            Method m = this.getMethod(op);
            MXBeanParametersNames namesAnn = m.getAnnotation(MXBeanParametersNames.class);
            if (namesAnn != null) {
                assert (namesAnn.value() != null);
                assert (seq < namesAnn.value().length);
                str = namesAnn.value()[seq];
                assert (str != null);
                assert (!str.trim().isEmpty());
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    private Method getMethod(MBeanOperationInfo op) throws ClassNotFoundException, SecurityException {
        String methodName = op.getName();
        MBeanParameterInfo[] signature2 = op.getSignature();
        Class[] params2 = new Class[signature2.length];
        for (int i = 0; i < signature2.length; ++i) {
            Class<?> type = primCls.get(signature2[i].getType().toLowerCase());
            if (type == null) {
                type = Class.forName(signature2[i].getType());
            }
            params2[i] = type;
        }
        return this.findMethod(this.getMBeanInterface(), methodName, params2);
    }

    private Method findMethod(Class itf, String methodName, Class[] params2) {
        Class<?>[] superItfs;
        assert (itf.isInterface());
        Method res = null;
        try {
            res = itf.getDeclaredMethod(methodName, params2);
            if (res != null) {
                return res;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Class<?> superItf : superItfs = itf.getInterfaces()) {
            res = this.findMethod(superItf, methodName, params2);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    static {
        primCls.put(Boolean.TYPE.toString().toLowerCase(), Boolean.TYPE);
        primCls.put(Character.TYPE.toString().toLowerCase(), Character.TYPE);
        primCls.put(Byte.TYPE.toString().toLowerCase(), Byte.TYPE);
        primCls.put(Short.TYPE.toString().toLowerCase(), Short.TYPE);
        primCls.put(Integer.TYPE.toString().toLowerCase(), Integer.TYPE);
        primCls.put(Long.TYPE.toString().toLowerCase(), Long.TYPE);
        primCls.put(Float.TYPE.toString().toLowerCase(), Float.TYPE);
        primCls.put(Double.TYPE.toString().toLowerCase(), Double.TYPE);
    }
}

