/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem.unsafe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.UnsafeChunk;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;

public class UnsafeMemoryProvider
implements DirectMemoryProvider {
    private long[] sizes;
    private List<DirectMemoryRegion> regions;
    private IgniteLogger log;
    private boolean isInit;
    private int used = 0;

    public UnsafeMemoryProvider(IgniteLogger log2) {
        this.log = log2;
    }

    @Override
    public void initialize(long[] sizes) {
        if (this.isInit) {
            return;
        }
        this.sizes = sizes;
        this.regions = new ArrayList<DirectMemoryRegion>();
        this.isInit = true;
    }

    @Override
    public void shutdown(boolean deallocate) {
        if (this.regions != null) {
            Iterator<DirectMemoryRegion> it = this.regions.iterator();
            while (it.hasNext()) {
                DirectMemoryRegion chunk = it.next();
                if (!deallocate) continue;
                GridUnsafe.freeMemory(chunk.address());
                it.remove();
            }
            if (!deallocate) {
                this.used = 0;
            }
        }
    }

    @Override
    public DirectMemoryRegion nextRegion() {
        long ptr;
        if (this.used == this.sizes.length) {
            return null;
        }
        if (this.used < this.regions.size()) {
            return this.regions.get(this.used++);
        }
        long chunkSize = this.sizes[this.regions.size()];
        try {
            ptr = GridUnsafe.allocateMemory(chunkSize);
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to allocate next memory chunk: " + U.readableSize(chunkSize, true) + ". Check if chunkSize is too large and 32-bit JVM is used.";
            if (this.regions.isEmpty()) {
                throw new IgniteException(msg, e);
            }
            U.error(this.log, msg);
            return null;
        }
        if (ptr <= 0L) {
            U.error(this.log, "Failed to allocate next memory chunk: " + U.readableSize(chunkSize, true));
            return null;
        }
        UnsafeChunk region = new UnsafeChunk(ptr, chunkSize);
        this.regions.add(region);
        ++this.used;
        return region;
    }
}

