/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectInputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.util.io.GridUnsafeDataInput;
import org.apache.ignite.internal.util.io.GridUnsafeDataOutput;
import org.apache.ignite.internal.util.typedef.internal.U;

class OptimizedObjectStreamRegistry {
    private static final ThreadLocal<StreamHolder> holders = new ThreadLocal();
    private static BlockingQueue<OptimizedObjectOutputStream> outPool;
    private static BlockingQueue<OptimizedObjectInputStream> inPool;

    private OptimizedObjectStreamRegistry() {
    }

    static void poolSize(int size2) {
        if (size2 > 0) {
            outPool = new LinkedBlockingQueue<OptimizedObjectOutputStream>(size2);
            inPool = new LinkedBlockingQueue<OptimizedObjectInputStream>(size2);
            for (int i = 0; i < size2; ++i) {
                outPool.offer(OptimizedObjectStreamRegistry.createOut());
                inPool.offer(OptimizedObjectStreamRegistry.createIn());
            }
        } else {
            outPool = null;
            inPool = null;
        }
    }

    static OptimizedObjectOutputStream out() throws IgniteInterruptedCheckedException {
        if (outPool != null) {
            try {
                return outPool.take();
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedCheckedException("Failed to take output object stream from pool (thread interrupted).", e);
            }
        }
        return OptimizedObjectStreamRegistry.holder().acquireOut();
    }

    static OptimizedObjectInputStream in() throws IgniteInterruptedCheckedException {
        if (inPool != null) {
            try {
                return inPool.take();
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedCheckedException("Failed to take input object stream from pool (thread interrupted).", e);
            }
        }
        return OptimizedObjectStreamRegistry.holder().acquireIn();
    }

    static void closeOut(OptimizedObjectOutputStream out) {
        U.close(out, null);
        if (outPool != null) {
            boolean b = outPool.offer(out);
            assert (b);
        } else {
            StreamHolder holder = holders.get();
            if (holder != null) {
                holder.releaseOut();
            }
        }
    }

    static void closeIn(OptimizedObjectInputStream in) {
        U.close(in, null);
        if (inPool != null) {
            boolean b = inPool.offer(in);
            assert (b);
        } else {
            StreamHolder holder = holders.get();
            if (holder != null) {
                holder.releaseIn();
            }
        }
    }

    private static StreamHolder holder() throws IgniteInterruptedCheckedException {
        StreamHolder holder = holders.get();
        if (holder == null) {
            holder = new StreamHolder();
            holders.set(holder);
        }
        return holder;
    }

    private static OptimizedObjectOutputStream createOut() {
        try {
            return new OptimizedObjectOutputStream(new GridUnsafeDataOutput(4096));
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create object output stream.", e);
        }
    }

    private static OptimizedObjectInputStream createIn() {
        try {
            return new OptimizedObjectInputStream(new GridUnsafeDataInput());
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create object input stream.", e);
        }
    }

    private static class StreamHolder {
        private final OptimizedObjectOutputStream out = OptimizedObjectStreamRegistry.access$100();
        private final OptimizedObjectInputStream in = OptimizedObjectStreamRegistry.access$200();
        private int outAcquireCnt;
        private int inAcquireCnt;

        private StreamHolder() {
        }

        OptimizedObjectOutputStream acquireOut() {
            return this.outAcquireCnt++ > 0 ? OptimizedObjectStreamRegistry.createOut() : this.out;
        }

        OptimizedObjectInputStream acquireIn() {
            return this.inAcquireCnt++ > 0 ? OptimizedObjectStreamRegistry.createIn() : this.in;
        }

        void releaseOut() {
            --this.outAcquireCnt;
        }

        void releaseIn() {
            --this.inAcquireCnt;
        }
    }
}

