/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class DiscoCache {
    private static final C1<BaselineNode, ClusterNode> BASELINE_TO_CLUSTER = new C1<BaselineNode, ClusterNode>(){

        @Override
        public ClusterNode apply(BaselineNode baselineNode) {
            return (ClusterNode)baselineNode;
        }
    };
    private final DiscoveryDataClusterState state;
    private final ClusterNode loc;
    private final List<ClusterNode> rmtNodes;
    private final List<ClusterNode> allNodes;
    private final List<ClusterNode> srvNodes;
    private final List<ClusterNode> daemonNodes;
    private final List<? extends BaselineNode> baselineNodes;
    @GridToStringInclude
    private final List<ClusterNode> rmtNodesWithCaches;
    @GridToStringInclude
    private final Map<Integer, List<ClusterNode>> allCacheNodes;
    @GridToStringInclude
    private final Map<Integer, List<ClusterNode>> cacheGrpAffNodes;
    final Map<UUID, ClusterNode> nodeMap;
    final Set<UUID> alives = new GridConcurrentHashSet<UUID>();
    private final IgniteProductVersion minNodeVer;
    private final IgniteProductVersion minSrvNodeVer;
    private final AffinityTopologyVersion topVer;
    final Map<UUID, Short> nodeIdToConsIdx;
    final Map<Short, UUID> consIdxToNodeId;
    private final P1<BaselineNode> aliveBaselineNodePred;
    private final P1<ClusterNode> aliveNodePred;
    private final MvccCoordinator mvccCrd;

    DiscoCache(AffinityTopologyVersion topVer, DiscoveryDataClusterState state, ClusterNode loc, MvccCoordinator mvccCrd, List<ClusterNode> rmtNodes, List<ClusterNode> allNodes, List<ClusterNode> srvNodes, List<ClusterNode> daemonNodes, List<ClusterNode> rmtNodesWithCaches, @Nullable List<? extends BaselineNode> baselineNodes, Map<Integer, List<ClusterNode>> allCacheNodes, Map<Integer, List<ClusterNode>> cacheGrpAffNodes, Map<UUID, ClusterNode> nodeMap, Set<UUID> alives0, @Nullable Map<UUID, Short> nodeIdToConsIdx, @Nullable Map<Short, UUID> consIdxToNodeId, IgniteProductVersion minNodeVer, IgniteProductVersion minSrvNodeVer) {
        this.topVer = topVer;
        this.state = state;
        this.loc = loc;
        this.mvccCrd = mvccCrd;
        this.rmtNodes = rmtNodes;
        this.allNodes = allNodes;
        this.srvNodes = srvNodes;
        this.daemonNodes = daemonNodes;
        this.rmtNodesWithCaches = rmtNodesWithCaches;
        this.baselineNodes = baselineNodes;
        this.allCacheNodes = allCacheNodes;
        this.cacheGrpAffNodes = cacheGrpAffNodes;
        this.nodeMap = nodeMap;
        this.alives.addAll(alives0);
        this.minNodeVer = minNodeVer;
        this.minSrvNodeVer = minSrvNodeVer;
        this.nodeIdToConsIdx = nodeIdToConsIdx;
        this.consIdxToNodeId = consIdxToNodeId;
        this.aliveBaselineNodePred = new P1<BaselineNode>(){

            @Override
            public boolean apply(BaselineNode node) {
                return node instanceof ClusterNode && DiscoCache.this.alives.contains(((ClusterNode)node).id());
            }
        };
        this.aliveNodePred = new P1<ClusterNode>(){

            @Override
            public boolean apply(ClusterNode node) {
                return DiscoCache.this.alives.contains(node.id());
            }
        };
    }

    @Nullable
    public MvccCoordinator mvccCoordinator() {
        return this.mvccCrd;
    }

    public AffinityTopologyVersion version() {
        return this.topVer;
    }

    public IgniteProductVersion minimumNodeVersion() {
        return this.minNodeVer;
    }

    public IgniteProductVersion minimumServerNodeVersion() {
        return this.minSrvNodeVer;
    }

    public DiscoveryDataClusterState state() {
        return this.state;
    }

    public ClusterNode localNode() {
        return this.loc;
    }

    public List<ClusterNode> remoteNodes() {
        return this.rmtNodes;
    }

    @Nullable
    public List<? extends BaselineNode> baselineNodes() {
        return this.baselineNodes;
    }

    public boolean baselineNode(UUID nodeId) {
        return this.nodeIdToConsIdx == null || this.nodeIdToConsIdx.containsKey(nodeId);
    }

    public List<ClusterNode> allNodes() {
        return this.allNodes;
    }

    public List<ClusterNode> serverNodes() {
        return this.srvNodes;
    }

    public List<ClusterNode> daemonNodes() {
        return this.daemonNodes;
    }

    public Map<UUID, Short> consistentIdMap() {
        return this.nodeIdToConsIdx;
    }

    public Map<Short, UUID> nodeIdMap() {
        return this.consIdxToNodeId;
    }

    public Collection<ClusterNode> remoteAliveNodesWithCaches() {
        return F.view(this.rmtNodesWithCaches, this.aliveNodePred);
    }

    public Collection<ClusterNode> aliveServerNodes() {
        return F.view(this.serverNodes(), this.aliveNodePred);
    }

    @Nullable
    public Collection<ClusterNode> aliveBaselineNodes() {
        return this.baselineNodes == null ? null : F.viewReadOnly(this.baselineNodes, BASELINE_TO_CLUSTER, this.aliveBaselineNodePred);
    }

    public boolean baselineNode(ClusterNode node) {
        return this.nodeIdToConsIdx == null || this.nodeIdToConsIdx.get(node.id()) != null;
    }

    @Nullable
    public ClusterNode oldestAliveServerNode() {
        for (int i = 0; i < this.srvNodes.size(); ++i) {
            ClusterNode srv = this.srvNodes.get(i);
            if (!this.alives.contains(srv.id())) continue;
            return srv;
        }
        return null;
    }

    @Nullable
    public ClusterNode oldestServerNode() {
        if (!this.srvNodes.isEmpty()) {
            return this.srvNodes.get(0);
        }
        return null;
    }

    public boolean alive(UUID nodeId) {
        return this.alives.contains(nodeId);
    }

    public List<ClusterNode> cacheNodes(@Nullable String cacheName) {
        return this.cacheNodes(CU.cacheId(cacheName));
    }

    public List<ClusterNode> cacheNodes(Integer cacheId) {
        return this.emptyIfNull(this.allCacheNodes.get(cacheId));
    }

    public List<ClusterNode> cacheGroupAffinityNodes(int grpId) {
        return this.emptyIfNull(this.cacheGrpAffNodes.get(grpId));
    }

    @Nullable
    public ClusterNode node(UUID id) {
        return this.nodeMap.get(id);
    }

    public void updateAlives(ClusterNode rmvd) {
        this.alives.remove(rmvd.id());
    }

    public void updateAlives(GridDiscoveryManager discovery) {
        for (UUID alive : this.alives) {
            if (discovery.alive(alive)) continue;
            this.alives.remove(alive);
        }
    }

    @Nullable
    public ClusterNode serverNodeByOrder(long order) {
        int idx = this.serverNodeBinarySearch(order);
        if (idx >= 0) {
            return this.srvNodes.get(idx);
        }
        return null;
    }

    private int serverNodeBinarySearch(long order) {
        int low = 0;
        int high = this.srvNodes.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            ClusterNode midVal = this.srvNodes.get(mid);
            int cmp = Long.compare(midVal.order(), order);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public <T> boolean checkAttribute(String name, T expVal) {
        for (ClusterNode node : this.allNodes) {
            Object attr = node.attribute(name);
            if (attr != null && expVal.equals(attr)) continue;
            return false;
        }
        return true;
    }

    private List<ClusterNode> emptyIfNull(List<ClusterNode> nodes2) {
        return nodes2 == null ? Collections.emptyList() : nodes2;
    }

    public DiscoCache copy(AffinityTopologyVersion ver, @Nullable DiscoveryDataClusterState state) {
        return new DiscoCache(ver, state == null ? this.state : state, this.loc, this.mvccCrd, this.rmtNodes, this.allNodes, this.srvNodes, this.daemonNodes, this.rmtNodesWithCaches, this.baselineNodes, this.allCacheNodes, this.cacheGrpAffNodes, this.nodeMap, this.alives, this.nodeIdToConsIdx, this.consIdxToNodeId, this.minNodeVer, this.minSrvNodeVer);
    }

    public String toString() {
        return S.toString(DiscoCache.class, this);
    }
}

