/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentClassLoader;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentMetadata;
import org.apache.ignite.internal.managers.deployment.GridDeploymentStoreAdapter;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.GridAnnotationsCache;
import org.apache.ignite.internal.util.GridClassLoaderCache;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.AbstractMarshaller;
import org.apache.ignite.spi.deployment.DeploymentSpi;

public class GridDeploymentPerLoaderStore
extends GridDeploymentStoreAdapter {
    private Map<IgniteUuid, IsolatedDeployment> cache = new HashMap<IgniteUuid, IsolatedDeployment>();
    private GridLocalEventListener discoLsnr;
    private ClassLoader ctxLdr;
    private final Object mux = new Object();

    GridDeploymentPerLoaderStore(DeploymentSpi spi, GridKernalContext ctx, GridDeploymentCommunication comm) {
        super(spi, ctx, comm);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctxLdr = U.detectClassLoader(this.getClass());
        this.discoLsnr = new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent);
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                if (evt.type() == 11 || evt.type() == 12) {
                    LinkedList<IsolatedDeployment> rmv = new LinkedList<IsolatedDeployment>();
                    Iterator iterator2 = GridDeploymentPerLoaderStore.this.mux;
                    synchronized (iterator2) {
                        Iterator iter2 = GridDeploymentPerLoaderStore.this.cache.values().iterator();
                        while (iter2.hasNext()) {
                            IsolatedDeployment dep = (IsolatedDeployment)iter2.next();
                            if (!dep.senderNodeId().equals(nodeId)) continue;
                            dep.undeploy();
                            iter2.remove();
                            rmv.add(dep);
                        }
                    }
                    for (IsolatedDeployment dep : rmv) {
                        dep.recordUndeployed();
                    }
                }
            }
        };
        this.ctx.event().addLocalEventListener(this.discoLsnr, 12, 11);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        HashSet<IsolatedDeployment> cp = new HashSet<IsolatedDeployment>();
        Iterator iterator2 = this.mux;
        synchronized (iterator2) {
            for (IsolatedDeployment dep : this.cache.values()) {
                dep.undeploy();
                cp.add(dep);
            }
            this.cache.clear();
        }
        for (IsolatedDeployment dep : cp) {
            dep.recordUndeployed();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStart() throws IgniteCheckedException {
        LinkedList<IsolatedDeployment> rmv = new LinkedList<IsolatedDeployment>();
        Iterator iterator2 = this.mux;
        synchronized (iterator2) {
            Iterator<IsolatedDeployment> iter2 = this.cache.values().iterator();
            while (iter2.hasNext()) {
                IsolatedDeployment dep = iter2.next();
                ClusterNode node = this.ctx.discovery().node(dep.senderNodeId());
                if (node != null) continue;
                dep.undeploy();
                iter2.remove();
                rmv.add(dep);
            }
        }
        for (IsolatedDeployment dep : rmv) {
            dep.recordUndeployed();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered deployment discovery listener: " + this.discoLsnr);
        }
    }

    @Override
    public void onKernalStop() {
        if (this.discoLsnr != null) {
            this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered deployment discovery listener: " + this.discoLsnr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GridDeployment> getDeployments() {
        Object object = this.mux;
        synchronized (object) {
            return new LinkedList<GridDeployment>(this.cache.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDeployment getDeployment(IgniteUuid ldrId) {
        Object object = this.mux;
        synchronized (object) {
            return this.cache.get(ldrId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDeployment getDeployment(GridDeploymentMetadata meta) {
        Class<?> cls;
        IsolatedDeployment dep;
        ClusterNode snd;
        assert (meta != null);
        assert (this.ctx.config().isPeerClassLoadingEnabled());
        assert (meta.classLoaderId() != null);
        assert (meta.senderNodeId() != null);
        assert (meta.sequenceNumber() > 0L) : "Invalid sequence number (must be positive): " + meta;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting to peer-load class based on deployment metadata: " + meta);
        }
        if ((snd = this.ctx.discovery().node(meta.senderNodeId())) == null) {
            U.warn(this.log, "Failed to create Private or Isolated mode deployment (sender node left grid): " + snd);
            return null;
        }
        Object object = this.mux;
        synchronized (object) {
            dep = this.cache.get(meta.classLoaderId());
            if (dep == null) {
                ClassLoader parent;
                long undeployTimeout = 0L;
                for (IsolatedDeployment d : this.cache.values()) {
                    if (!d.senderNodeId().equals(meta.senderNodeId()) || d.undeployed() || d.pendingUndeploy()) continue;
                    if (d.sequenceNumber() < meta.sequenceNumber()) {
                        if (d.existingDeployedClass(meta.className()) == null) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received request for a class with newer sequence number (will schedule current class for undeployment) [cls=" + meta.className() + ", newSeq=" + meta.sequenceNumber() + ", oldSeq=" + d.sequenceNumber() + ", senderNodeId=" + meta.senderNodeId() + ", curClsLdrId=" + d.classLoaderId() + ", newClsLdrId=" + meta.classLoaderId() + ']');
                        }
                        this.scheduleUndeploy(d, this.ctx.config().getNetworkTimeout());
                        continue;
                    }
                    if (d.sequenceNumber() > meta.sequenceNumber()) {
                        if (d.deployedClass(meta.className(), new String[0]) == null) continue;
                        long time = U.currentTimeMillis() - d.timestamp();
                        if (time < this.ctx.config().getNetworkTimeout()) {
                            undeployTimeout = this.ctx.config().getNetworkTimeout() - time;
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Received execution request for a stale class (will deploy and schedule undeployment in " + undeployTimeout + "ms) [cls=" + meta.className() + ", curSeq=" + d.sequenceNumber() + ", rcvdSeq=" + meta.sequenceNumber() + ", senderNodeId=" + meta.senderNodeId() + ", curClsLdrId=" + d.classLoaderId() + ", rcvdClsLdrId=" + meta.classLoaderId() + ']');
                            continue;
                        }
                        U.warn(this.log, "Received execution request for a class that has been redeployed (will ignore): " + meta.alias());
                        return null;
                    }
                    U.error(this.log, "Sequence number does not correspond to class loader ID [seqNum=" + meta.sequenceNumber() + ", dep=" + d + ']');
                    return null;
                }
                ClassLoader classLoader = parent = meta.parentLoader() == null ? this.ctxLdr : meta.parentLoader();
                if (parent == null) {
                    parent = this.getClass().getClassLoader();
                }
                GridDeploymentClassLoader clsLdr = new GridDeploymentClassLoader(meta.classLoaderId(), meta.userVersion(), meta.deploymentMode(), true, this.ctx, parent, meta.classLoaderId(), meta.senderNodeId(), this.comm, this.ctx.config().getNetworkTimeout(), this.log, this.ctx.config().getPeerClassLoadingLocalClassPathExclude(), this.ctx.config().getPeerClassLoadingMissedResourcesCacheSize(), false, false);
                dep = new IsolatedDeployment(meta.deploymentMode(), clsLdr, meta.classLoaderId(), meta.userVersion(), snd, meta.className());
                this.cache.put(meta.classLoaderId(), dep);
                if (undeployTimeout > 0L) {
                    this.scheduleUndeploy(dep, undeployTimeout);
                }
            }
        }
        if (dep != null && (cls = dep.deployedClass(meta.className(), meta.alias())) == null) {
            U.warn(this.log, "Failed to load peer class [alias=" + meta.alias() + ", dep=" + dep + ']');
            return null;
        }
        return dep;
    }

    @Override
    public void addParticipants(Map<UUID, IgniteUuid> allParticipants, Map<UUID, IgniteUuid> addedParticipants) {
        assert (false);
    }

    private void scheduleUndeploy(final IsolatedDeployment dep, long timeout) {
        assert (Thread.holdsLock(this.mux));
        if (!dep.undeployed() && !dep.pendingUndeploy()) {
            dep.onUndeployScheduled();
            this.ctx.timeout().addTimeoutObject(new GridTimeoutObjectAdapter(dep.classLoaderId(), timeout){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTimeout() {
                    boolean rmv = false;
                    Object object = GridDeploymentPerLoaderStore.this.mux;
                    synchronized (object) {
                        if (!dep.undeployed()) {
                            dep.undeploy();
                            GridDeploymentPerLoaderStore.this.cache.remove(dep.classLoaderId());
                            rmv = true;
                        }
                    }
                    if (rmv) {
                        dep.recordUndeployed();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void explicitUndeploy(UUID nodeId, String rsrcName) {
        assert (nodeId != null);
        assert (rsrcName != null);
        LinkedList<IsolatedDeployment> undeployed = new LinkedList<IsolatedDeployment>();
        Iterator iterator2 = this.mux;
        synchronized (iterator2) {
            Iterator<IsolatedDeployment> iter2 = this.cache.values().iterator();
            while (iter2.hasNext()) {
                IsolatedDeployment dep = iter2.next();
                if (!dep.senderNodeId().equals(nodeId) || !dep.hasName(rsrcName)) continue;
                iter2.remove();
                dep.undeploy();
                undeployed.add(dep);
                if (!this.log.isInfoEnabled()) continue;
                this.log.info("Undeployed Private or Isolated deployment: " + dep);
            }
        }
        for (IsolatedDeployment dep : undeployed) {
            dep.recordUndeployed();
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDeploymentPerLoaderStore.class, this);
    }

    private class IsolatedDeployment
    extends GridDeployment {
        private final ClusterNode sndNode;

        IsolatedDeployment(DeploymentMode depMode, ClassLoader clsLdr, IgniteUuid clsLdrId, String userVer, ClusterNode sndNode, String sampleClsName) {
            super(depMode, clsLdr, clsLdrId, userVer, sampleClsName, false);
            this.sndNode = sndNode;
        }

        UUID senderNodeId() {
            return this.sndNode.id();
        }

        @Override
        public void onDeployed(Class<?> cls) {
            this.recordDeployed(cls, true);
        }

        void recordDeployed(Class<?> cls, boolean recordEvt) {
            assert (!Thread.holdsLock(GridDeploymentPerLoaderStore.this.mux));
            boolean isTask = GridDeploymentPerLoaderStore.this.isTask(cls);
            String msg = (isTask ? "Task" : "Class") + " was deployed in Private or Isolated mode: " + cls;
            if (recordEvt && GridDeploymentPerLoaderStore.this.ctx.event().isRecordable(GridDeploymentPerLoaderStore.this.isTask(cls) ? 33 : 30)) {
                DeploymentEvent evt = new DeploymentEvent();
                evt.type(isTask ? 33 : 30);
                evt.node(this.sndNode);
                evt.message(msg);
                evt.alias(cls.getName());
                GridDeploymentPerLoaderStore.this.ctx.event().record(evt);
            }
            if (GridDeploymentPerLoaderStore.this.log.isInfoEnabled()) {
                GridDeploymentPerLoaderStore.this.log.info(msg);
            }
        }

        void recordUndeployed() {
            assert (!Thread.holdsLock(GridDeploymentPerLoaderStore.this.mux));
            GridEventStorageManager evts = GridDeploymentPerLoaderStore.this.ctx.event();
            if (evts.isRecordable(31) || evts.isRecordable(34)) {
                for (Map.Entry<String, Class<?>> depCls : this.deployedClassMap().entrySet()) {
                    boolean isTask = GridDeploymentPerLoaderStore.this.isTask(depCls.getValue());
                    String msg = (isTask ? "Task" : "Class") + " was undeployed in Private or Isolated mode [cls=" + depCls.getValue() + ", alias=" + depCls.getKey() + ']';
                    if (evts.isRecordable(!isTask ? 31 : 34)) {
                        DeploymentEvent evt = new DeploymentEvent();
                        evt.node(this.sndNode);
                        evt.message(msg);
                        evt.type(!isTask ? 31 : 34);
                        evt.alias(depCls.getKey());
                        evts.record(evt);
                    }
                    if (!GridDeploymentPerLoaderStore.this.log.isInfoEnabled()) continue;
                    GridDeploymentPerLoaderStore.this.log.info(msg);
                }
            }
            if (this.obsolete()) {
                GridDeploymentPerLoaderStore.this.ctx.resource().onUndeployed(this);
                ClassLoader ldr = this.classLoader();
                GridDeploymentPerLoaderStore.this.ctx.cache().onUndeployed(ldr);
                if (GridDeploymentPerLoaderStore.this.ctx.config().getMarshaller() instanceof AbstractMarshaller) {
                    ((AbstractMarshaller)GridDeploymentPerLoaderStore.this.ctx.config().getMarshaller()).onUndeploy(ldr);
                }
                GridDeploymentPerLoaderStore.this.clearSerializationCaches();
                GridAnnotationsCache.onUndeployed(ldr);
                GridClassLoaderCache.onUndeployed(ldr);
            }
        }

        @Override
        public String toString() {
            return S.toString(IsolatedDeployment.class, this, super.toString());
        }
    }
}

