/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;

class GridDeploymentMetadata {
    private DeploymentMode depMode;
    private String alias;
    private String clsName;
    private String userVer;
    private UUID sndNodeId;
    private IgniteUuid clsLdrId;
    private ClassLoader clsLdr;
    @GridToStringInclude
    private Map<UUID, IgniteUuid> participants;
    private ClassLoader parentLdr;
    private boolean record;
    private IgnitePredicate<ClusterNode> nodeFilter;

    GridDeploymentMetadata() {
    }

    GridDeploymentMetadata(GridDeploymentMetadata meta) {
        assert (meta != null);
        this.depMode = meta.deploymentMode();
        this.alias = meta.alias();
        this.clsName = meta.className();
        this.userVer = meta.userVersion();
        this.sndNodeId = meta.senderNodeId();
        this.clsLdr = meta.classLoader();
        this.clsLdrId = meta.classLoaderId();
        this.participants = meta.participants();
        this.parentLdr = meta.parentLoader();
        this.record = meta.record();
        this.nodeFilter = meta.nodeFilter();
    }

    DeploymentMode deploymentMode() {
        return this.depMode;
    }

    void deploymentMode(DeploymentMode depMode) {
        this.depMode = depMode;
    }

    String alias() {
        return this.alias;
    }

    void alias(String alias) {
        this.alias = alias;
    }

    String className() {
        return this.clsName;
    }

    void className(String clsName) {
        this.clsName = clsName;
    }

    long sequenceNumber() {
        return this.clsLdrId.localId();
    }

    String userVersion() {
        return this.userVer;
    }

    void userVersion(String userVer) {
        this.userVer = userVer;
    }

    UUID senderNodeId() {
        return this.sndNodeId;
    }

    void senderNodeId(UUID sndNodeId) {
        this.sndNodeId = sndNodeId;
    }

    IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    void classLoaderId(IgniteUuid clsLdrId) {
        this.clsLdrId = clsLdrId;
    }

    public ClassLoader parentLoader() {
        return this.parentLdr;
    }

    public void parentLoader(ClassLoader parentLdr) {
        this.parentLdr = parentLdr;
    }

    boolean record() {
        return this.record;
    }

    void record(boolean record2) {
        this.record = record2;
    }

    public Map<UUID, IgniteUuid> participants() {
        return this.participants;
    }

    public void participants(Map<UUID, IgniteUuid> participants) {
        this.participants = participants;
    }

    public ClassLoader classLoader() {
        return this.clsLdr;
    }

    public void classLoader(ClassLoader clsLdr) {
        this.clsLdr = clsLdr;
    }

    public void nodeFilter(IgnitePredicate<ClusterNode> nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public IgnitePredicate<ClusterNode> nodeFilter() {
        return this.nodeFilter;
    }

    public String toString() {
        return S.toString(GridDeploymentMetadata.class, this, "seqNum", this.clsLdrId != null ? Long.valueOf(this.clsLdrId.localId()) : "n/a");
    }
}

