/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.jdbc2.JdbcQueryTaskResult;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

class JdbcQueryTask
implements IgniteCallable<JdbcQueryTaskResult> {
    private static final long serialVersionUID = 0L;
    private static final long RMV_DELAY = IgniteSystemProperties.getLong("IGNITE_JDBC_DRIVER_CURSOR_RMV_DELAY", 600000L);
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private static final ConcurrentMap<UUID, Cursor> CURSORS = new ConcurrentHashMap<UUID, Cursor>();
    @IgniteInstanceResource
    private Ignite ignite;
    private final UUID uuid;
    private final String cacheName;
    private final String schemaName;
    private final String sql;
    private Boolean isQry;
    private final Object[] args;
    private final int fetchSize;
    private final boolean loc;
    private final boolean locQry;
    private final boolean collocatedQry;
    private final boolean distributedJoins;

    public JdbcQueryTask(Ignite ignite, String cacheName, String schemaName, String sql2, Boolean isQry, boolean loc, Object[] args2, int fetchSize, UUID uuid, boolean locQry, boolean collocatedQry, boolean distributedJoins) {
        this.ignite = ignite;
        this.args = args2;
        this.uuid = uuid;
        this.cacheName = cacheName;
        this.schemaName = schemaName;
        this.sql = sql2;
        this.isQry = isQry;
        this.fetchSize = fetchSize;
        this.loc = loc;
        this.locQry = locQry;
        this.collocatedQry = collocatedQry;
        this.distributedJoins = distributedJoins;
    }

    @Override
    public JdbcQueryTaskResult call() throws Exception {
        boolean finished;
        Cursor cursor = (Cursor)CURSORS.get(this.uuid);
        ArrayList<String> tbls = null;
        ArrayList<String> cols = null;
        ArrayList<String> types2 = null;
        boolean first = cursor == null;
        if (first) {
            IgniteCache cache = this.ignite.cache(this.cacheName);
            boolean start = this.ignite.configuration().isClientMode();
            if (cache == null && this.cacheName == null) {
                cache = ((IgniteKernal)this.ignite).context().cache().getOrStartPublicCache(start, !this.loc && this.locQry);
            }
            if (cache == null) {
                if (this.cacheName == null) {
                    throw new SQLException("Failed to execute query. No suitable caches found.");
                }
                throw new SQLException("Cache not found [cacheName=" + this.cacheName + ']');
            }
            SqlFieldsQuery qry = (this.isQry != null ? new SqlFieldsQueryEx(this.sql, this.isQry) : new SqlFieldsQuery(this.sql)).setArgs(this.args);
            qry.setPageSize(this.fetchSize);
            qry.setLocal(this.locQry);
            qry.setCollocated(this.collocatedQry);
            qry.setDistributedJoins(this.distributedJoins);
            qry.setEnforceJoinOrder(this.enforceJoinOrder());
            qry.setLazy(this.lazy());
            qry.setSchema(this.schemaName);
            FieldsQueryCursor<List<?>> fldQryCursor = cache.withKeepBinary().query(qry);
            if (fldQryCursor instanceof BulkLoadContextCursor) {
                fldQryCursor.close();
                throw new SQLException("COPY command is currently supported only in thin JDBC driver.");
            }
            QueryCursorImpl qryCursor = (QueryCursorImpl)fldQryCursor;
            if (this.isQry == null) {
                this.isQry = qryCursor.isQuery();
            }
            cursor = new Cursor(qryCursor, qryCursor.iterator());
            CURSORS.put(this.uuid, cursor);
        }
        if (first || this.updateMetadata()) {
            List<GridQueryFieldMetadata> meta = cursor.queryCursor().fieldsMeta();
            tbls = new ArrayList<String>(meta.size());
            cols = new ArrayList<String>(meta.size());
            types2 = new ArrayList<String>(meta.size());
            for (GridQueryFieldMetadata desc : meta) {
                tbls.add(desc.typeName());
                cols.add(desc.fieldName().toUpperCase());
                types2.add(desc.fieldTypeName());
            }
        }
        ArrayList rows = new ArrayList();
        for (List<?> row : cursor) {
            ArrayList row0 = new ArrayList(row.size());
            for (Object val : row) {
                row0.add(val == null || JdbcUtils.isSqlType(val.getClass()) ? val : val.toString());
            }
            rows.add(row0);
            if (rows.size() != this.fetchSize) continue;
            break;
        }
        boolean bl = finished = !cursor.hasNext();
        if (finished) {
            JdbcQueryTask.remove(this.uuid, cursor);
        } else if (first) {
            if (!this.loc) {
                JdbcQueryTask.scheduleRemoval(this.uuid);
            }
        } else if (!this.loc && !CURSORS.replace(this.uuid, cursor, new Cursor(cursor.cursor, cursor.iter))) assert (!CURSORS.containsKey(this.uuid)) : "Concurrent cursor modification.";
        assert (this.isQry != null) : "Query flag must be set prior to returning result";
        return new JdbcQueryTaskResult(this.uuid, finished, this.isQry, rows, cols, tbls, types2);
    }

    protected boolean enforceJoinOrder() {
        return false;
    }

    protected boolean lazy() {
        return false;
    }

    protected boolean updateMetadata() {
        return false;
    }

    protected boolean skipReducerOnUpdate() {
        return false;
    }

    static void scheduleRemoval(UUID uuid) {
        JdbcQueryTask.scheduleRemoval(uuid, RMV_DELAY);
    }

    private static void scheduleRemoval(final UUID uuid, long delay) {
        SCHEDULER.schedule(new CAX(){

            @Override
            public void applyx() {
                Cursor c;
                while ((c = (Cursor)CURSORS.get(uuid)) != null) {
                    long untouchedTime = U.currentTimeMillis() - c.lastAccessTime;
                    if (untouchedTime < RMV_DELAY) {
                        JdbcQueryTask.scheduleRemoval(uuid, RMV_DELAY - untouchedTime);
                        break;
                    }
                    if (!JdbcQueryTask.remove(uuid, c)) continue;
                    break;
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private static boolean remove(UUID uuid, Cursor c) {
        boolean rmv = CURSORS.remove(uuid, c);
        if (rmv) {
            c.cursor.close();
        }
        return rmv;
    }

    static void addCursor(UUID uuid, Cursor c) {
        CURSORS.putIfAbsent(uuid, c);
    }

    static void remove(UUID uuid) {
        Cursor c = (Cursor)CURSORS.remove(uuid);
        if (c != null) {
            c.cursor.close();
        }
    }

    static final class Cursor
    implements Iterable<List<?>> {
        final QueryCursor<List<?>> cursor;
        final Iterator<List<?>> iter;
        final long lastAccessTime;

        Cursor(QueryCursor<List<?>> cursor, Iterator<List<?>> iter2) {
            this.cursor = cursor;
            this.iter = iter2;
            this.lastAccessTime = U.currentTimeMillis();
        }

        @Override
        public Iterator<List<?>> iterator() {
            return this.iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public QueryCursorImpl<List<?>> queryCursor() {
            return (QueryCursorImpl)this.cursor;
        }
    }
}

