/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.internal.jdbc2.JdbcResultSet;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

public class JdbcDatabaseMetadata
implements DatabaseMetaData {
    public static final String DRIVER_NAME = "Apache Ignite JDBC Driver";
    private final JdbcConnection conn;
    private Map<String, Map<String, Map<String, ColumnInfo>>> meta;
    private Collection<List<Object>> indexes;

    JdbcDatabaseMetadata(JdbcConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.conn.url();
    }

    @Override
    public String getUserName() {
        return "";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        return "Apache Ignite";
    }

    @Override
    public String getDatabaseProductVersion() {
        return IgniteVersionUtils.VER.toString();
    }

    @Override
    public int getDatabaseMajorVersion() {
        return IgniteVersionUtils.VER.major();
    }

    @Override
    public int getDatabaseMinorVersion() {
        return IgniteVersionUtils.VER.minor();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return IgniteVersionUtils.VER.toString();
    }

    @Override
    public int getDriverMajorVersion() {
        return IgniteVersionUtils.VER.major();
    }

    @Override
    public int getDriverMinorVersion() {
        return IgniteVersionUtils.VER.minor();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "LIMIT,MINUS,ROWNUM,SYSDATE,SYSTIME,SYSTIMESTAMP,TODAY";
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType2, int toType) {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return this.conn.isMultipleStatementsAllowed();
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "";
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPtrn, String procedureNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPtrn, String procedureNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), Integer.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Short.class.getName(), Short.class.getName(), Short.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName()), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPtrn, String tblNamePtrn, String[] tblTypes) throws SQLException {
        this.updateMetaData();
        LinkedList rows = new LinkedList();
        if (JdbcDatabaseMetadata.validCatalogPattern(catalog) && (tblTypes == null || Arrays.asList(tblTypes).contains("TABLE"))) {
            for (Map.Entry<String, Map<String, Map<String, ColumnInfo>>> schema : this.meta.entrySet()) {
                if (!JdbcDatabaseMetadata.matches(schema.getKey(), schemaPtrn)) continue;
                for (String tbl : schema.getValue().keySet()) {
                    if (!JdbcDatabaseMetadata.matches(tbl, tblNamePtrn)) continue;
                    rows.add(this.tableRow(schema.getKey(), tbl));
                }
            }
        }
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()), rows, true);
    }

    private List<Object> tableRow(String schema, String tbl) {
        ArrayList<Object> row = new ArrayList<Object>(10);
        row.add(null);
        row.add(schema);
        row.add(tbl.toUpperCase());
        row.add("TABLE");
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        return row;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, "%");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.singletonList("TABLE_CAT"), Collections.singletonList(String.class.getName()), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.singletonList("TABLE_TYPE"), Collections.singletonList(String.class.getName()), Collections.singletonList(Collections.singletonList("TABLE")), true);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        this.updateMetaData();
        LinkedList rows = new LinkedList();
        int cnt = 0;
        if (JdbcDatabaseMetadata.validCatalogPattern(catalog)) {
            for (Map.Entry<String, Map<String, Map<String, ColumnInfo>>> schema : this.meta.entrySet()) {
                if (!JdbcDatabaseMetadata.matches(schema.getKey(), schemaPtrn)) continue;
                for (Map.Entry<String, Map<String, ColumnInfo>> tbl : schema.getValue().entrySet()) {
                    if (!JdbcDatabaseMetadata.matches(tbl.getKey(), tblNamePtrn)) continue;
                    for (Map.Entry<String, ColumnInfo> col : tbl.getValue().entrySet()) {
                        rows.add(this.columnRow(schema.getKey(), tbl.getKey(), col.getKey(), JdbcUtils.type(col.getValue().typeName()), JdbcUtils.typeName(col.getValue().typeName()), !col.getValue().isNotNull(), ++cnt));
                    }
                }
            }
        }
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName(), String.class.getName()), rows, true);
    }

    private List<Object> columnRow(String schema, String tbl, String col, int type, String typeName, boolean nullable, int pos) {
        ArrayList<Object> row = new ArrayList<Object>(20);
        row.add(null);
        row.add(schema);
        row.add(tbl);
        row.add(col);
        row.add(type);
        row.add(typeName);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(10);
        row.add(nullable ? 1 : 0);
        row.add(null);
        row.add(null);
        row.add(type);
        row.add(null);
        row.add(Integer.MAX_VALUE);
        row.add(pos);
        row.add(nullable ? "YES" : "NO");
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add("NO");
        row.add("NO");
        return row;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String tbl, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String tbl, int scope, boolean nullable) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        this.updateMetaData();
        LinkedList rows = new LinkedList();
        if (JdbcDatabaseMetadata.validCatalogPattern(catalog)) {
            for (Map.Entry<String, Map<String, Map<String, ColumnInfo>>> schema : this.meta.entrySet()) {
                if (!JdbcDatabaseMetadata.matches(schema.getKey(), schemaPtrn)) continue;
                for (Map.Entry<String, Map<String, ColumnInfo>> tbl : schema.getValue().entrySet()) {
                    if (!JdbcDatabaseMetadata.matches(tbl.getKey(), tblNamePtrn)) continue;
                    rows.add(Arrays.asList(null, schema.getKey(), tbl.getKey(), "_KEY", 1, "_KEY"));
                }
            }
        }
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), rows, true);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTbl, String foreignCatalog, String foreignSchema, String foreignTbl) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tbl, boolean unique2, boolean approximate2) throws SQLException {
        this.updateMetaData();
        ArrayList rows = new ArrayList(this.indexes.size());
        if (JdbcDatabaseMetadata.validCatalogPattern(catalog)) {
            for (List<Object> idx : this.indexes) {
                String idxSchema = (String)idx.get(0);
                String idxTbl = (String)idx.get(1);
                if (schema != null && !schema.equals(idxSchema) || tbl != null && !tbl.equals(idxTbl)) continue;
                ArrayList<Object> row = new ArrayList<Object>(13);
                row.add(null);
                row.add(idxSchema);
                row.add(idxTbl);
                row.add(idx.get(2));
                row.add(null);
                row.add(idx.get(3));
                row.add(3);
                row.add(idx.get(4));
                row.add(idx.get(5));
                row.add((Boolean)idx.get(6) != false ? "D" : "A");
                row.add(0);
                row.add(0);
                row.add(null);
                rows.add(row);
            }
        }
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), Boolean.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), Short.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName()), rows, true);
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPtrn, String typeNamePtrn, int[] types2) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPtrn, String typeNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPtrn, String typeNamePtrn, String attributeNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 1;
    }

    @Override
    public int getSQLStateType() {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPtrn) throws SQLException {
        this.updateMetaData();
        ArrayList rows = new ArrayList(this.meta.size());
        if (JdbcDatabaseMetadata.validCatalogPattern(catalog)) {
            for (String schema : this.meta.keySet()) {
                if (!JdbcDatabaseMetadata.matches(schema, schemaPtrn)) continue;
                rows.add(Arrays.asList(schema, null));
            }
        }
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG"), Arrays.asList(String.class.getName(), String.class.getName()), rows, true);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPtrn, String functionNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "REMARKS", "FUNCTION_TYPE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPtrn, String functionNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), Integer.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Short.class.getName(), Short.class.getName(), Short.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName()), Collections.emptyList(), true);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(true, null, this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Database meta data is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface == DatabaseMetaData.class;
    }

    private void updateMetaData() throws SQLException {
        if (this.conn.isClosed()) {
            throw new SQLException("Connection is closed.", "08003");
        }
        try {
            IgniteKernal ignite = this.conn.ignite();
            UUID nodeId = this.conn.nodeId();
            UpdateMetadataTask task2 = new UpdateMetadataTask(this.conn.cacheName(), nodeId == null ? ignite : null);
            Collection<GridCacheSqlMetadata> metas = nodeId == null ? task2.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(task2);
            this.meta = U.newHashMap(metas.size());
            this.indexes = new ArrayList<List<Object>>();
            for (GridCacheSqlMetadata m : metas) {
                String name = m.cacheName();
                if (name == null) {
                    name = "PUBLIC";
                }
                Collection<String> types2 = m.types();
                HashMap typesMap = U.newHashMap(types2.size());
                for (String type : types2) {
                    Collection<String> notNullFields = m.notNullFields(type);
                    LinkedHashMap<String, ColumnInfo> fields = new LinkedHashMap<String, ColumnInfo>();
                    for (Map.Entry<String, String> fld : m.fields(type).entrySet()) {
                        ColumnInfo colInfo = new ColumnInfo(fld.getValue(), notNullFields == null ? false : notNullFields.contains(fld.getKey()));
                        fields.put(fld.getKey(), colInfo);
                    }
                    typesMap.put(type.toUpperCase(), fields);
                    for (GridCacheSqlIndexMetadata idx : m.indexes(type)) {
                        int cnt = 0;
                        for (String field2 : idx.fields()) {
                            this.indexes.add(F.asList(new Object[]{name, type.toUpperCase(), !idx.unique(), idx.name(), ++cnt, field2, idx.descending(field2)}));
                        }
                    }
                }
                this.meta.put(name, typesMap);
            }
        }
        catch (Exception e) {
            throw JdbcUtils.convertToSqlException(e, "Failed to get meta data from Ignite.");
        }
    }

    private static boolean matches(String str, String ptrn) {
        return str != null && (ptrn == null || str.matches(ptrn.replace("%", ".*").replace("_", ".")));
    }

    private static boolean validCatalogPattern(String catalog) {
        return F.isEmpty(catalog) || "%".equals(catalog);
    }

    private static class ColumnInfo {
        private final String typeName;
        private final boolean notNull;

        private ColumnInfo(String typeName, boolean notNull) {
            this.typeName = typeName;
            this.notNull = notNull;
        }

        public String typeName() {
            return this.typeName;
        }

        public boolean isNotNull() {
            return this.notNull;
        }
    }

    private static class UpdateMetadataTask
    implements IgniteCallable<Collection<GridCacheSqlMetadata>> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        private final String cacheName;

        public UpdateMetadataTask(String cacheName, Ignite ignite) {
            this.cacheName = cacheName;
            this.ignite = ignite;
        }

        @Override
        public Collection<GridCacheSqlMetadata> call() throws Exception {
            IgniteCache cache = this.ignite.cache(this.cacheName);
            return ((IgniteCacheProxy)cache).context().queries().sqlMetadataV2();
        }
    }
}

