/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinResultSet;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadAckResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteMultipleStatementsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParser;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcThinStatement
implements Statement {
    private static final int DFLT_PAGE_SIZE = 1024;
    protected JdbcThinConnection conn;
    private final String schema;
    private boolean closed;
    private int maxRows;
    private int timeout;
    private int pageSize = 1024;
    private final int resHoldability;
    protected int batchSize;
    protected List<JdbcQuery> batch;
    private boolean closeOnCompletion;
    protected List<JdbcThinResultSet> resultSets;
    protected int curRes;

    JdbcThinStatement(JdbcThinConnection conn, int resHoldability, String schema) {
        assert (conn != null);
        this.conn = conn;
        this.resHoldability = resHoldability;
        this.schema = schema;
    }

    @Override
    public ResultSet executeQuery(String sql2) throws SQLException {
        this.execute0(JdbcStatementType.SELECT_STATEMENT_TYPE, sql2, null);
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + sql2, "42000");
        }
        return rs;
    }

    private SqlCommand tryParseNative(String sql2) {
        try {
            return new SqlParser(this.schema, sql2).nextCommand();
        }
        catch (SqlParseException e) {
            return null;
        }
    }

    private static boolean isEligibleForNativeParsing(String sql2) {
        if (F.isEmpty(sql2)) {
            return false;
        }
        int setPos = (sql2 = sql2.toUpperCase()).indexOf("SET");
        if (setPos == -1) {
            return false;
        }
        int streamingPos = sql2.indexOf("STREAMING");
        return streamingPos - setPos - "SET".length() >= 1;
    }

    protected void execute0(JdbcStatementType stmtType, String sql2, List<Object> args2) throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        if (sql2 == null || sql2.isEmpty()) {
            throw new SQLException("SQL query is empty.");
        }
        this.checkStatementBatchEmpty();
        SqlCommand nativeCmd = null;
        if (stmtType != JdbcStatementType.SELECT_STATEMENT_TYPE && JdbcThinStatement.isEligibleForNativeParsing(sql2)) {
            nativeCmd = this.tryParseNative(sql2);
        }
        if (nativeCmd != null) {
            this.conn.executeNative(sql2, nativeCmd);
            this.resultSets = Collections.singletonList(this.resultSetForUpdate(0L));
            return;
        }
        if (this.conn.isStream()) {
            if (stmtType == JdbcStatementType.SELECT_STATEMENT_TYPE) {
                throw new SQLException("executeQuery() method is not allowed in streaming mode.", "50000", 1002);
            }
            this.conn.addBatch(sql2, args2);
            this.resultSets = Collections.singletonList(this.resultSetForUpdate(0L));
            return;
        }
        Object res0 = this.conn.sendRequest(new JdbcQueryExecuteRequest(stmtType, this.schema, this.pageSize, this.maxRows, this.conn.getAutoCommit(), sql2, args2 == null ? null : args2.toArray(new Object[args2.size()])));
        assert (res0 != null);
        if (res0 instanceof JdbcBulkLoadAckResult) {
            res0 = this.sendFile((JdbcBulkLoadAckResult)res0);
        }
        if (res0 instanceof JdbcQueryExecuteResult) {
            JdbcQueryExecuteResult res = (JdbcQueryExecuteResult)res0;
            this.resultSets = Collections.singletonList(new JdbcThinResultSet(this, res.getQueryId(), this.pageSize, res.last(), res.items(), res.isQuery(), this.conn.autoCloseServerCursor(), res.updateCount(), this.closeOnCompletion));
        } else if (res0 instanceof JdbcQueryExecuteMultipleStatementsResult) {
            JdbcQueryExecuteMultipleStatementsResult res = (JdbcQueryExecuteMultipleStatementsResult)res0;
            List<JdbcResultInfo> resInfos = res.results();
            this.resultSets = new ArrayList<JdbcThinResultSet>(resInfos.size());
            boolean firstRes = true;
            for (JdbcResultInfo rsInfo : resInfos) {
                if (!rsInfo.isQuery()) {
                    this.resultSets.add(this.resultSetForUpdate(rsInfo.updateCount()));
                    continue;
                }
                if (firstRes) {
                    firstRes = false;
                    this.resultSets.add(new JdbcThinResultSet(this, rsInfo.queryId(), this.pageSize, res.isLast(), res.items(), true, this.conn.autoCloseServerCursor(), -1L, this.closeOnCompletion));
                    continue;
                }
                this.resultSets.add(new JdbcThinResultSet(this, rsInfo.queryId(), this.pageSize, false, null, true, this.conn.autoCloseServerCursor(), -1L, this.closeOnCompletion));
            }
        } else {
            throw new SQLException("Unexpected result [res=" + res0 + ']');
        }
        assert (!this.resultSets.isEmpty()) : "At least one results set is expected";
    }

    void checkStatementBatchEmpty() throws SQLException {
        if (this.conn.isStream() && !F.isEmpty(this.batch)) {
            throw new IgniteSQLException("Statement has non-empty batch (call executeBatch() or clearBatch() before enabling streaming).", 1002).toJdbcException();
        }
    }

    private JdbcThinResultSet resultSetForUpdate(long cnt) {
        return new JdbcThinResultSet(this, -1L, this.pageSize, true, Collections.emptyList(), false, this.conn.autoCloseServerCursor(), cnt, this.closeOnCompletion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JdbcResult sendFile(JdbcBulkLoadAckResult cmdRes) throws SQLException {
        String fileName = cmdRes.params().localFileName();
        int batchSize = cmdRes.params().packetSize();
        int batchNum = 0;
        try (BufferedInputStream input2 = new BufferedInputStream(new FileInputStream(fileName));){
            int readBytes;
            byte[] buf = new byte[batchSize];
            while ((readBytes = ((InputStream)input2).read(buf)) != -1) {
                Object res;
                if (readBytes == 0 || (res = this.conn.sendRequest(new JdbcBulkLoadBatchRequest(cmdRes.queryId(), batchNum++, 0, readBytes == buf.length ? buf : Arrays.copyOf(buf, readBytes)))) instanceof JdbcQueryExecuteResult) continue;
                throw new SQLException("Unknown response sent by the server: " + res);
            }
            Object r = this.conn.sendRequest(new JdbcBulkLoadBatchRequest(cmdRes.queryId(), batchNum++, 2));
            return r;
        }
        catch (Exception e) {
            try {
                this.conn.sendRequest(new JdbcBulkLoadBatchRequest(cmdRes.queryId(), batchNum, 1));
            }
            catch (SQLException e1) {
                throw new SQLException("Cannot send finalization request: " + e1.getMessage(), e);
            }
            if (!(e instanceof SQLException)) throw new SQLException("Failed to read file: '" + fileName + "'", "50000", e);
            throw (SQLException)e;
        }
    }

    @Override
    public int executeUpdate(String sql2) throws SQLException {
        this.execute0(JdbcStatementType.UPDATE_STMT_TYPE, sql2, null);
        int res = this.getUpdateCount();
        if (res == -1) {
            throw new SQLException("The query is not DML statememt: " + sql2);
        }
        return res;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.closeResults();
        }
        finally {
            this.closed = true;
        }
    }

    private void closeResults() throws SQLException {
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                rs.close0();
            }
            this.resultSets = null;
            this.curRes = 0;
        }
    }

    void closeOnDisconnect() {
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                rs.closeOnDisconnect();
            }
            this.resultSets = null;
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max2) throws SQLException {
        this.ensureNotClosed();
        if (max2 < 0) {
            throw new SQLException("Invalid field limit.");
        }
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        if (maxRows < 0) {
            throw new SQLException("Invalid max rows value.");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.timeout / 1000;
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout value.");
        }
        this.timeout = timeout * 1000;
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql2) throws SQLException {
        this.ensureNotClosed();
        this.execute0(JdbcStatementType.ANY_STATEMENT_TYPE, sql2, null);
        return this.resultSets.get(0).isQuery();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        JdbcThinResultSet rs = this.nextResultSet();
        if (rs == null) {
            return null;
        }
        if (!rs.isQuery()) {
            --this.curRes;
            return null;
        }
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        JdbcThinResultSet rs = this.nextResultSet();
        if (rs == null) {
            return -1;
        }
        if (rs.isQuery()) {
            --this.curRes;
            return -1;
        }
        return (int)rs.updatedCount();
    }

    private JdbcThinResultSet nextResultSet() throws SQLException {
        this.ensureNotClosed();
        if (this.resultSets == null || this.curRes >= this.resultSets.size()) {
            return null;
        }
        return this.resultSets.get(this.curRes++);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureNotClosed();
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.pageSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.pageSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql2) throws SQLException {
        this.ensureNotClosed();
        this.checkStatementEligibleForBatching(sql2);
        this.checkStatementBatchEmpty();
        ++this.batchSize;
        if (this.conn.isStream()) {
            this.conn.addBatch(sql2, null);
            return;
        }
        if (this.batch == null) {
            this.batch = new ArrayList<JdbcQuery>();
        }
        this.batch.add(new JdbcQuery(sql2, null));
    }

    void checkStatementEligibleForBatching(String sql2) throws SQLException {
        SqlCommand nativeCmd = null;
        if (JdbcThinStatement.isEligibleForNativeParsing(sql2)) {
            nativeCmd = this.tryParseNative(sql2);
        }
        if (nativeCmd != null) {
            assert (nativeCmd instanceof SqlSetStreamingCommand);
            throw new SQLException("Streaming control commands must be executed explicitly - either via Statement.execute(String), or via using prepared statements.", "0A000");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batchSize = 0;
        this.batch = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        this.checkStatementBatchEmpty();
        if (this.conn.isStream()) {
            int[] res = new int[this.batchSize];
            this.batchSize = 0;
            return res;
        }
        if (F.isEmpty(this.batch)) {
            throw new SQLException("Batch is empty.");
        }
        try {
            JdbcBatchExecuteResult res = (JdbcBatchExecuteResult)this.conn.sendRequest(new JdbcBatchExecuteRequest(this.conn.getSchema(), this.batch, this.conn.getAutoCommit(), false));
            if (res.errorCode() != 0) {
                throw new BatchUpdateException(res.errorMessage(), IgniteQueryErrorCode.codeToSqlState(res.errorCode()), res.errorCode(), res.updateCounts());
            }
            int[] nArray = res.updateCounts();
            return nArray;
        }
        finally {
            this.batchSize = 0;
            this.batch = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int curr) throws SQLException {
        this.ensureNotClosed();
        if (this.resultSets != null) {
            assert (this.curRes <= this.resultSets.size()) : "Invalid results state: [resultsCount=" + this.resultSets.size() + ", curRes=" + this.curRes + ']';
            switch (curr) {
                case 1: {
                    if (this.curRes <= 0) break;
                    this.resultSets.get(this.curRes - 1).close0();
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.curRes; ++i) {
                        this.resultSets.get(i).close0();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new SQLException("Invalid 'current' parameter.");
                }
            }
        }
        return this.resultSets != null && this.curRes < this.resultSets.size();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int executeUpdate(String sql2, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.executeUpdate(sql2);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value");
    }

    @Override
    public int executeUpdate(String sql2, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int executeUpdate(String sql2, String[] colNames2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public boolean execute(String sql2, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.execute(sql2);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value.");
    }

    @Override
    public boolean execute(String sql2, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (colIndexes != null && colIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql2);
    }

    @Override
    public boolean execute(String sql2, String[] colNames2) throws SQLException {
        this.ensureNotClosed();
        if (colNames2 != null && colNames2.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql2);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.resHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed() || this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinStatement.class);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureNotClosed();
        this.closeOnCompletion = true;
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                rs.closeStatement(true);
            }
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return this.closeOnCompletion;
    }

    void timeout(int timeout) {
        this.timeout = timeout;
    }

    JdbcThinConnection connection() {
        return this.conn;
    }

    protected void ensureNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
    }

    void closeIfAllResultsClosed() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        boolean allRsClosed = true;
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                if (rs.isClosed()) continue;
                allRsClosed = false;
            }
        }
        if (allRsClosed) {
            this.close();
        }
    }
}

