/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinParameterMetadata;
import org.apache.ignite.internal.jdbc.thin.JdbcThinResultSet;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinUtils;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;

public class JdbcThinPreparedStatement
extends JdbcThinStatement
implements PreparedStatement {
    private final String sql;
    protected ArrayList<Object> args;
    private JdbcThinParameterMetadata metaData;

    JdbcThinPreparedStatement(JdbcThinConnection conn, String sql2, int resHoldability, String schema) {
        super(conn, resHoldability, schema);
        this.sql = sql2;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeWithArguments(JdbcStatementType.SELECT_STATEMENT_TYPE);
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + this.sql, "42000");
        }
        return rs;
    }

    @Override
    public ResultSet executeQuery(String sql2) throws SQLException {
        throw new SQLException("The method 'executeQuery(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeWithArguments(JdbcStatementType.UPDATE_STMT_TYPE);
        int res = this.getUpdateCount();
        if (res == -1) {
            throw new SQLException("The query is not DML statement: " + this.sql, "42000");
        }
        return res;
    }

    @Override
    public int executeUpdate(String sql2) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql2, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql2, int[] columnIndexes) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql2, String[] columnNames) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, String[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void setNull(int paramIdx, int sqlType) throws SQLException {
        this.setArgument(paramIdx, null);
    }

    @Override
    public void setBoolean(int paramIdx, boolean x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setByte(int paramIdx, byte x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setShort(int paramIdx, short x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setInt(int paramIdx, int x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setLong(int paramIdx, long x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setFloat(int paramIdx, float x) throws SQLException {
        this.setArgument(paramIdx, Float.valueOf(x));
    }

    @Override
    public void setDouble(int paramIdx, double x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setBigDecimal(int paramIdx, BigDecimal x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setString(int paramIdx, String x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setBytes(int paramIdx, byte[] x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setDate(int paramIdx, Date x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, int length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setUnicodeStream(int paramIdx, InputStream x, int length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, int length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureNotClosed();
        this.args = null;
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setObject(int paramIdx, Object x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeWithArguments(JdbcStatementType.ANY_STATEMENT_TYPE);
        return ((JdbcThinResultSet)this.resultSets.get(0)).isQuery();
    }

    private void executeWithArguments(JdbcStatementType stmtType) throws SQLException {
        this.execute0(stmtType, this.sql, this.args);
    }

    @Override
    public boolean execute(String sql2) throws SQLException {
        throw new SQLException("The method 'execute(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureNotClosed();
        this.checkStatementEligibleForBatching(this.sql);
        this.checkStatementBatchEmpty();
        ++this.batchSize;
        if (this.conn.isStream()) {
            this.conn.addBatch(this.sql, this.args);
        } else if (this.batch == null) {
            this.batch = new ArrayList();
            this.batch.add(new JdbcQuery(this.sql, this.args.toArray(new Object[this.args.size()])));
        } else {
            this.batch.add(new JdbcQuery(null, this.args.toArray(new Object[this.args.size()])));
        }
        this.args = null;
    }

    @Override
    public void addBatch(String sql2) throws SQLException {
        throw new SQLException("The method 'addBatch(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, int length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setRef(int paramIdx, Ref x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, Blob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Clob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setArray(int paramIdx, Array x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Meta data for prepared statement is not supported.");
    }

    @Override
    public void setDate(int paramIdx, Date x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setNull(int paramIdx, int sqlType, String typeName) throws SQLException {
        if (!JdbcThinUtils.isPlainJdbcType(sqlType)) {
            throw new SQLFeatureNotSupportedException("The SQL type is unsupported. [type=" + sqlType + "typeName=" + typeName + ']');
        }
        this.setNull(paramIdx, sqlType);
    }

    @Override
    public void setURL(int paramIdx, URL x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.ensureNotClosed();
        if (this.metaData != null) {
            return this.metaData;
        }
        JdbcMetaParamsResult res = (JdbcMetaParamsResult)this.conn.sendRequest(new JdbcMetaParamsRequest(this.conn.getSchema(), this.sql));
        this.metaData = new JdbcThinParameterMetadata(res.meta());
        return this.metaData;
    }

    @Override
    public void setRowId(int paramIdx, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNString(int paramIdx, String val) throws SQLException {
        this.ensureNotClosed();
        this.setString(paramIdx, val);
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Reader reader, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, Reader reader, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setSQLXML(int paramIdx, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, long length) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Prepared statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinPreparedStatement.class);
    }

    private void setArgument(int paramIdx, Object val) throws SQLException {
        this.ensureNotClosed();
        if (val != null && !SqlListenerUtils.isPlainType(val.getClass())) {
            throw new SQLException("Parameter type is unsupported. [cls=" + val.getClass() + ']', "22023");
        }
        if (paramIdx < 1) {
            throw new SQLException("Parameter index is invalid: " + paramIdx);
        }
        if (this.args == null) {
            this.args = new ArrayList(paramIdx);
        }
        while (this.args.size() < paramIdx) {
            this.args.add(null);
        }
        this.args.set(paramIdx - 1, val);
    }
}

