/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.JdbcThinDatabaseMetadata;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPreparedStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteProductVersion;

public class JdbcThinConnection
implements Connection {
    private static final Logger LOG = Logger.getLogger(JdbcThinConnection.class.getName());
    private final Object stmtsMux = new Object();
    private String schema;
    private boolean closed;
    private int txIsolation;
    private boolean autoCommit;
    private boolean readOnly;
    private volatile StreamState streamState;
    private int holdability;
    private int timeout;
    private JdbcThinTcpIo cliIo;
    private JdbcThinDatabaseMetadata metadata;
    private ConnectionProperties connProps;
    private boolean connected;
    private final ArrayList<JdbcThinStatement> stmts = new ArrayList();

    public JdbcThinConnection(ConnectionProperties connProps) throws SQLException {
        this.connProps = connProps;
        this.holdability = 1;
        this.autoCommit = true;
        this.txIsolation = 0;
        this.schema = JdbcThinConnection.normalizeSchema(connProps.getSchema());
        this.cliIo = new JdbcThinTcpIo(connProps);
        this.ensureConnected();
    }

    private synchronized void ensureConnected() throws SQLException {
        try {
            if (this.connected) {
                return;
            }
            assert (!this.closed);
            this.cliIo.start();
            this.connected = true;
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new SQLException("Failed to connect to Ignite cluster [url=" + this.connProps.getUrl() + ']', "08001", e);
        }
    }

    boolean isStream() {
        return this.streamState != null;
    }

    void executeNative(String sql2, SqlCommand cmd) throws SQLException {
        if (cmd instanceof SqlSetStreamingCommand) {
            boolean newVal;
            SqlSetStreamingCommand cmd0 = (SqlSetStreamingCommand)cmd;
            if (this.streamState != null) {
                this.streamState.close();
                this.streamState = null;
            }
            if (newVal = ((SqlSetStreamingCommand)cmd).isTurnOn()) {
                if (!cmd0.isOrdered() && !this.cliIo.isUnorderedStreamSupported()) {
                    throw new SQLException("Streaming without order doesn't supported by server [remoteNodeVer=" + this.cliIo.igniteVersion() + ']', "50000");
                }
                this.sendRequest(new JdbcQueryExecuteRequest(JdbcStatementType.ANY_STATEMENT_TYPE, this.schema, 1, 1, this.autoCommit, sql2, null));
                this.streamState = new StreamState((SqlSetStreamingCommand)cmd);
            }
        } else {
            throw IgniteQueryErrorCode.createJdbcSqlException("Unsupported native statement: " + sql2, 1002);
        }
    }

    void addBatch(String sql2, List<Object> args2) throws SQLException {
        assert (this.isStream());
        this.streamState.addBatch(sql2, args2);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        JdbcThinStatement stmt = new JdbcThinStatement(this, resSetHoldability, this.schema);
        if (this.timeout > 0) {
            stmt.timeout(this.timeout);
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql2) throws SQLException {
        return this.prepareStatement(sql2, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int resSetType, int resSetConcurrency) throws SQLException {
        return this.prepareStatement(sql2, resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql2, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        if (sql2 == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        JdbcThinPreparedStatement stmt = new JdbcThinPreparedStatement(this, sql2, resSetHoldability, this.schema);
        if (this.timeout > 0) {
            stmt.timeout(this.timeout);
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    private void checkCursorOptions(int resSetType, int resSetConcurrency) throws SQLException {
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported).");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql2, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public String nativeSQL(String sql2) throws SQLException {
        this.ensureNotClosed();
        if (sql2 == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        return sql2;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (autoCommit != this.autoCommit) {
            this.doCommit();
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be committed explicitly in auto-commit mode.");
        }
        this.doCommit();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be rolled back explicitly in auto-commit mode.");
        }
        try (Statement s2 = this.createStatement();){
            s2.execute("ROLLBACK");
        }
    }

    private void doCommit() throws SQLException {
        try (Statement s2 = this.createStatement();){
            s2.execute("COMMIT");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.streamState != null) {
            this.streamState.close();
            this.streamState = null;
        }
        this.closed = true;
        this.cliIo.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        if (this.metadata == null) {
            this.metadata = new JdbcThinDatabaseMetadata(this);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new SQLException("Invalid transaction isolation level.", "0700E");
            }
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 1 && holdability != 2) {
            throw new SQLException("Invalid result set holdability value.");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        if (name == null) {
            throw new SQLException("Savepoint name cannot be null.");
        }
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Invalid savepoint.");
        }
        if (this.autoCommit) {
            throw new SQLException("Auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Savepoint cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql2, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, String[] colNames2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        return !this.closed;
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements2) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinConnection.class);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureNotClosed();
        this.schema = JdbcThinConnection.normalizeSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureNotClosed();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor cannot be null.");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        this.ensureNotClosed();
        if (executor == null) {
            throw new SQLException("Executor cannot be null.");
        }
        if (ms < 0) {
            throw new SQLException("Network timeout cannot be negative.");
        }
        this.timeout = ms;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.timeout;
    }

    public void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    IgniteProductVersion igniteVersion() {
        return this.cliIo.igniteVersion();
    }

    boolean autoCloseServerCursor() {
        return this.connProps.isAutoCloseServerCursor();
    }

    <R extends JdbcResult> R sendRequest(JdbcRequest req) throws SQLException {
        this.ensureConnected();
        try {
            JdbcResponse res = this.cliIo.sendRequest(req);
            if (res.status() != 0) {
                throw new SQLException(res.error(), IgniteQueryErrorCode.codeToSqlState(res.status()), res.status());
            }
            return (R)res.response();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            this.onDisconnect();
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", e);
        }
    }

    private void sendRequestNotWaitResponse(JdbcOrderedBatchExecuteRequest req) throws SQLException {
        this.ensureConnected();
        try {
            this.cliIo.sendBatchRequestNoWaitResponse(req);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            this.onDisconnect();
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", e);
        }
    }

    public String url() {
        return this.connProps.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnect() {
        if (!this.connected) {
            return;
        }
        this.cliIo.close();
        this.connected = false;
        if (this.streamState != null) {
            this.streamState.close0();
            this.streamState = null;
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            for (JdbcThinStatement s2 : this.stmts) {
                s2.closeOnDisconnect();
            }
            this.stmts.clear();
        }
    }

    private static String normalizeSchema(String schemaName) {
        if (F.isEmpty(schemaName)) {
            return "PUBLIC";
        }
        String res = schemaName.startsWith("\"") && schemaName.endsWith("\"") ? schemaName.substring(1, schemaName.length() - 1) : schemaName.toUpperCase();
        return res;
    }

    private class StreamState {
        private static final int MAX_REQUESTS_BEFORE_RESPONSE = 10;
        private static final long WAIT_TIMEOUT = 1L;
        private int streamBatchSize;
        private List<JdbcQuery> streamBatch;
        private String lastStreamQry;
        private long order;
        private Thread asyncRespReaderThread;
        private volatile Exception err;
        private long lastRespOrder = -1L;
        private final GridFutureAdapter<Void> lastRespFut = new GridFutureAdapter();
        private Semaphore respSem = new Semaphore(10);

        StreamState(SqlSetStreamingCommand cmd) {
            this.streamBatchSize = cmd.batchSize();
            this.asyncRespReaderThread = new Thread(this::readResponses);
            this.asyncRespReaderThread.start();
        }

        void addBatch(String sql2, List<Object> args2) throws SQLException {
            this.checkError();
            boolean newQry = args2 == null || !F.eq(this.lastStreamQry, sql2);
            JdbcQuery q = new JdbcQuery(newQry ? sql2 : null, args2 != null ? args2.toArray() : null);
            if (this.streamBatch == null) {
                this.streamBatch = new ArrayList<JdbcQuery>(this.streamBatchSize);
            }
            this.streamBatch.add(q);
            String string2 = this.lastStreamQry = args2 != null ? sql2 : null;
            if (this.streamBatch.size() == this.streamBatchSize) {
                this.executeBatch(false);
            }
        }

        private void executeBatch(boolean lastBatch) throws SQLException {
            block6: {
                this.checkError();
                if (lastBatch) {
                    this.lastRespOrder = this.order;
                }
                try {
                    this.respSem.acquire();
                    JdbcThinConnection.this.sendRequestNotWaitResponse(new JdbcOrderedBatchExecuteRequest(JdbcThinConnection.this.schema, this.streamBatch, JdbcThinConnection.this.autoCommit, lastBatch, this.order));
                    this.streamBatch = null;
                    this.lastStreamQry = null;
                    if (lastBatch) {
                        try {
                            this.lastRespFut.get();
                        }
                        catch (IgniteCheckedException igniteCheckedException) {
                            // empty catch block
                        }
                        this.checkError();
                        break block6;
                    }
                    ++this.order;
                }
                catch (InterruptedException e) {
                    throw new SQLException("Streaming operation was interrupted", "50000", e);
                }
            }
        }

        void checkError() throws SQLException {
            if (this.err != null) {
                Exception err0 = this.err;
                this.err = null;
                if (err0 instanceof SQLException) {
                    throw (SQLException)err0;
                }
                JdbcThinConnection.this.onDisconnect();
                throw new SQLException("Failed to communicate with Ignite cluster on JDBC streaming.", "08006", err0);
            }
        }

        void close() throws SQLException {
            this.close0();
            this.checkError();
        }

        void close0() {
            if (JdbcThinConnection.this.connected) {
                try {
                    this.executeBatch(true);
                }
                catch (SQLException e) {
                    this.err = e;
                    LOG.log(Level.WARNING, "Exception during batch send on streamed connection close", e);
                }
            }
            if (this.asyncRespReaderThread != null) {
                this.asyncRespReaderThread.interrupt();
            }
        }

        void readResponses() {
            try {
                while (true) {
                    JdbcResponse resp;
                    if ((resp = JdbcThinConnection.this.cliIo.readResponse()).response() instanceof JdbcOrderedBatchExecuteResult) {
                        JdbcOrderedBatchExecuteResult res = (JdbcOrderedBatchExecuteResult)resp.response();
                        this.respSem.release();
                        if (res.errorCode() != 0) {
                            this.err = new BatchUpdateException(res.errorMessage(), IgniteQueryErrorCode.codeToSqlState(res.errorCode()), res.errorCode(), res.updateCounts());
                        }
                        if (res.order() == this.lastRespOrder) {
                            this.lastRespFut.onDone();
                            break;
                        }
                    }
                    if (resp.status() == 0) continue;
                    this.err = new SQLException(resp.error(), IgniteQueryErrorCode.codeToSqlState(resp.status()));
                }
            }
            catch (Exception e) {
                this.err = e;
            }
        }
    }
}

