/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcResultSet;
import org.apache.ignite.internal.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

@Deprecated
public class JdbcStatement
implements Statement {
    private static final String TASK_NAME = "org.apache.ignite.internal.processors.cache.query.jdbc.GridCacheQueryJdbcTask";
    private static final int DFLT_FETCH_SIZE = 1024;
    private final JdbcConnection conn;
    private boolean closed;
    private int maxRows;
    private int timeout;
    private ResultSet rs;
    protected Object[] args;
    private int fetchSize = 1024;

    JdbcStatement(JdbcConnection conn) {
        assert (conn != null);
        this.conn = conn;
    }

    @Override
    public ResultSet executeQuery(String sql2) throws SQLException {
        this.ensureNotClosed();
        this.rs = null;
        if (sql2 == null || sql2.isEmpty()) {
            throw new SQLException("SQL query is empty");
        }
        try {
            byte[] packet = (byte[])this.conn.client().compute().execute(TASK_NAME, JdbcUtils.marshalArgument(JdbcUtils.taskArgument(this.conn.nodeId(), this.conn.cacheName(), sql2, this.timeout, this.args, this.fetchSize, this.maxRows)));
            byte status = packet[0];
            byte[] data = new byte[packet.length - 1];
            U.arrayCopy(packet, 1, data, 0, data.length);
            if (status == 1) {
                throw JdbcUtils.unmarshalError(data);
            }
            List msg = (List)JdbcUtils.unmarshal(data);
            assert (msg.size() == 7);
            UUID nodeId = (UUID)msg.get(0);
            UUID futId = (UUID)msg.get(1);
            List tbls = (List)msg.get(2);
            List cols = (List)msg.get(3);
            List types2 = (List)msg.get(4);
            Collection fields = (Collection)msg.get(5);
            boolean finished = (Boolean)msg.get(6);
            return new JdbcResultSet(this, nodeId, futId, tbls, cols, types2, fields, finished, this.fetchSize);
        }
        catch (GridClientException e) {
            throw new SQLException("Failed to query Ignite.", e);
        }
    }

    @Override
    public int executeUpdate(String sql2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        this.timeout = timeout * 1000;
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Cancellation is not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql2) throws SQLException {
        this.ensureNotClosed();
        this.rs = this.executeQuery(sql2);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureNotClosed();
        ResultSet rs0 = this.rs;
        this.rs = null;
        return rs0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureNotClosed();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int curr) throws SQLException {
        this.ensureNotClosed();
        if (curr == 2 || curr == 3) {
            throw new SQLFeatureNotSupportedException("Multiple open results are not supported.");
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public int executeUpdate(String sql2, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public int executeUpdate(String sql2, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public int executeUpdate(String sql2, String[] colNames2) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql2, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("Updates are not supported.");
        }
        return this.execute(sql2);
    }

    @Override
    public boolean execute(String sql2, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (colIndexes != null && colIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException("Updates are not supported.");
        }
        return this.execute(sql2);
    }

    @Override
    public boolean execute(String sql2, String[] colNames2) throws SQLException {
        this.ensureNotClosed();
        if (colNames2 != null && colNames2.length > 0) {
            throw new SQLFeatureNotSupportedException("Updates are not supported.");
        }
        return this.execute(sql2);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == Statement.class;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("closeOnCompletion is not supported.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    void timeout(int timeout) {
        this.timeout = timeout;
    }

    JdbcConnection connection() {
        return this.conn;
    }

    protected void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Statement is closed.");
        }
    }
}

