/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcResultSet;
import org.apache.ignite.internal.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

@Deprecated
public class JdbcDatabaseMetadata
implements DatabaseMetaData {
    private static final String TASK_NAME = "org.apache.ignite.internal.processors.cache.query.jdbc.GridCacheQueryJdbcMetadataTask";
    private final JdbcConnection conn;
    private Map<String, Map<String, Map<String, String>>> meta;
    private Collection<List<Object>> indexes;

    JdbcDatabaseMetadata(JdbcConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.url();
    }

    @Override
    public String getUserName() throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Apache Ignite";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "4.1.0";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Ignite JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType2, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPtrn, String procedureNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), Collections.emptyList());
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPtrn, String procedureNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), Integer.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Short.class.getName(), Short.class.getName(), Short.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName()), Collections.emptyList());
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPtrn, String tblNamePtrn, String[] tblTypes) throws SQLException {
        this.updateMetaData();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        if (tblTypes == null || Arrays.asList(tblTypes).contains("TABLE")) {
            for (Map.Entry<String, Map<String, Map<String, String>>> schema : this.meta.entrySet()) {
                if (!this.matches(schema.getKey(), schemaPtrn)) continue;
                for (String tbl : schema.getValue().keySet()) {
                    if (!this.matches(tbl, tblNamePtrn)) continue;
                    rows.add(this.tableRow(schema.getKey(), tbl));
                }
            }
        }
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()), rows);
    }

    private List<Object> tableRow(String schema, String tbl) {
        ArrayList<Object> row = new ArrayList<Object>(10);
        row.add(null);
        row.add(schema);
        row.add(tbl.toUpperCase());
        row.add("TABLE");
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        return row;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, "%");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT"), Arrays.asList(String.class.getName()), Collections.emptyList());
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.singletonList("TABLE_TYPE"), Collections.singletonList(String.class.getName()), Collections.singletonList(Collections.singletonList("TABLE")));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        this.updateMetaData();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        int cnt = 0;
        for (Map.Entry<String, Map<String, Map<String, String>>> schema : this.meta.entrySet()) {
            if (!this.matches(schema.getKey(), schemaPtrn)) continue;
            for (Map.Entry<String, Map<String, String>> tbl : schema.getValue().entrySet()) {
                if (!this.matches(tbl.getKey(), tblNamePtrn)) continue;
                for (Map.Entry<String, String> col : tbl.getValue().entrySet()) {
                    rows.add(this.columnRow(schema.getKey(), tbl.getKey(), col.getKey(), JdbcUtils.type(col.getValue()), JdbcUtils.typeName(col.getValue()), JdbcUtils.nullable(col.getKey(), col.getValue()), ++cnt));
                }
            }
        }
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), rows);
    }

    private List<Object> columnRow(String schema, String tbl, String col, int type, String typeName, boolean nullable, int pos) {
        ArrayList<Object> row = new ArrayList<Object>(20);
        row.add(null);
        row.add(schema);
        row.add(tbl);
        row.add(col);
        row.add(type);
        row.add(typeName);
        row.add(null);
        row.add(null);
        row.add(10);
        row.add(nullable ? 1 : 0);
        row.add(null);
        row.add(null);
        row.add(Integer.MAX_VALUE);
        row.add(pos);
        row.add("YES");
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add("NO");
        return row;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String tbl, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String tbl, int scope, boolean nullable) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String tbl) throws SQLException {
        this.updateMetaData();
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        for (Map.Entry<String, Map<String, Map<String, String>>> s2 : this.meta.entrySet()) {
            if (schema != null && !schema.toUpperCase().equals(s2.getKey())) continue;
            for (Map.Entry<String, Map<String, String>> t : s2.getValue().entrySet()) {
                if (tbl != null && !tbl.toUpperCase().equals(t.getKey())) continue;
                rows.add(Arrays.asList(null, s2.getKey().toUpperCase(), t.getKey().toUpperCase(), "_KEY", 1, "_KEY"));
            }
        }
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), rows);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String tbl) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTbl, String foreignCatalog, String foreignSchema, String foreignTbl) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tbl, boolean unique2, boolean approximate2) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(this.indexes.size());
        for (List<Object> idx : this.indexes) {
            String idxSchema = (String)idx.get(0);
            String idxTbl = (String)idx.get(1);
            if (schema != null && !schema.equals(idxSchema) || tbl != null && !tbl.equals(idxTbl)) continue;
            ArrayList<Object> row = new ArrayList<Object>(13);
            row.add(null);
            row.add(idxSchema);
            row.add(idxTbl);
            row.add((Boolean)idx.get(2));
            row.add(null);
            row.add((String)idx.get(3));
            row.add(3);
            row.add((Integer)idx.get(4));
            row.add((String)idx.get(5));
            row.add((Boolean)idx.get(6) != false ? "D" : "A");
            row.add(0);
            row.add(0);
            row.add(null);
            rows.add(row);
        }
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), Boolean.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), Short.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName()), rows);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPtrn, String typeNamePtrn, int[] types2) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPtrn, String typeNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPtrn, String tblNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPtrn, String typeNamePtrn, String attributeNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPtrn) throws SQLException {
        this.updateMetaData();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(this.meta.size());
        for (String schema : this.meta.keySet()) {
            if (!this.matches(schema, schemaPtrn)) continue;
            rows.add(Arrays.asList(schema, null));
        }
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG"), Arrays.asList(String.class.getName(), String.class.getName()), rows);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPtrn, String functionNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "REMARKS", "FUNCTION_TYPE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), String.class.getName()), Collections.emptyList());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPtrn, String functionNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Arrays.asList("FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"), Arrays.asList(String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Short.class.getName(), Integer.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), Short.class.getName(), Short.class.getName(), Short.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName()), Collections.emptyList());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Database meta data is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == DatabaseMetaData.class;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPtrn, String tblNamePtrn, String colNamePtrn) throws SQLException {
        return new JdbcResultSet(this.conn.createStatement0(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    private void updateMetaData() throws SQLException {
        if (this.conn.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
        try {
            byte[] packet = (byte[])this.conn.client().compute().execute(TASK_NAME, this.conn.cacheName());
            byte status = packet[0];
            byte[] data = new byte[packet.length - 1];
            U.arrayCopy(packet, 1, data, 0, data.length);
            if (status == 1) {
                throw JdbcUtils.unmarshalError(data);
            }
            List res = (List)JdbcUtils.unmarshal(data);
            this.meta = (Map)res.get(0);
            this.indexes = (Collection)res.get(1);
        }
        catch (GridClientException e) {
            throw new SQLException("Failed to get meta data from Ignite.", e);
        }
    }

    private boolean matches(String str, String ptrn) {
        return str != null && (ptrn == null || str.toUpperCase().matches(ptrn.toUpperCase().replace("%", ".*").replace("_", ".")));
    }
}

