/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.igfs.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.igfs.common.IgfsControlResponse;
import org.apache.ignite.internal.igfs.common.IgfsHandshakeRequest;
import org.apache.ignite.internal.igfs.common.IgfsIpcCommand;
import org.apache.ignite.internal.igfs.common.IgfsMessage;
import org.apache.ignite.internal.igfs.common.IgfsModeResolverRequest;
import org.apache.ignite.internal.igfs.common.IgfsPathControlRequest;
import org.apache.ignite.internal.igfs.common.IgfsStatusRequest;
import org.apache.ignite.internal.igfs.common.IgfsStreamControlRequest;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IgfsMarshaller {
    public static final int HEADER_SIZE = 24;

    public static byte[] createHeader(long reqId, IgfsIpcCommand cmd) {
        assert (cmd != null);
        byte[] hdr = new byte[24];
        U.longToBytes(reqId, hdr, 0);
        U.intToBytes(cmd.ordinal(), hdr, 8);
        return hdr;
    }

    public static byte[] fillHeader(byte[] hdr, long reqId, IgfsIpcCommand cmd) {
        assert (cmd != null);
        Arrays.fill(hdr, (byte)0);
        U.longToBytes(reqId, hdr, 0);
        U.intToBytes(cmd.ordinal(), hdr, 8);
        return hdr;
    }

    public void marshall(IgfsMessage msg, byte[] hdr, ObjectOutput out) throws IgniteCheckedException {
        assert (hdr != null);
        assert (hdr.length == 24);
        try {
            switch (msg.command()) {
                case HANDSHAKE: {
                    out.write(hdr);
                    IgfsHandshakeRequest req = (IgfsHandshakeRequest)msg;
                    U.writeString(out, req.igfsName());
                    U.writeString(out, req.logDirectory());
                    break;
                }
                case STATUS: {
                    out.write(hdr);
                    break;
                }
                case EXISTS: 
                case INFO: 
                case PATH_SUMMARY: 
                case UPDATE: 
                case RENAME: 
                case DELETE: 
                case MAKE_DIRECTORIES: 
                case LIST_PATHS: 
                case LIST_FILES: 
                case AFFINITY: 
                case SET_TIMES: 
                case OPEN_READ: 
                case OPEN_APPEND: 
                case OPEN_CREATE: {
                    out.write(hdr);
                    IgfsPathControlRequest req = (IgfsPathControlRequest)msg;
                    U.writeString(out, req.userName());
                    this.writePath(out, req.path());
                    this.writePath(out, req.destinationPath());
                    out.writeBoolean(req.flag());
                    out.writeBoolean(req.colocate());
                    IgfsUtils.writeStringMap(out, req.properties());
                    if (msg.command() == IgfsIpcCommand.AFFINITY) {
                        out.writeLong(req.start());
                        out.writeLong(req.length());
                        break;
                    }
                    if (msg.command() == IgfsIpcCommand.OPEN_CREATE) {
                        out.writeInt(req.replication());
                        out.writeLong(req.blockSize());
                        break;
                    }
                    if (msg.command() == IgfsIpcCommand.SET_TIMES) {
                        out.writeLong(req.accessTime());
                        out.writeLong(req.modificationTime());
                        break;
                    }
                    if (msg.command() == IgfsIpcCommand.OPEN_READ && req.flag()) {
                        out.writeInt(req.sequentialReadsBeforePrefetch());
                    }
                    break;
                }
                case CLOSE: 
                case READ_BLOCK: 
                case WRITE_BLOCK: {
                    assert (msg.command() != IgfsIpcCommand.WRITE_BLOCK) : "WRITE_BLOCK should be marshalled manually.";
                    IgfsStreamControlRequest req = (IgfsStreamControlRequest)msg;
                    U.longToBytes(req.streamId(), hdr, 12);
                    if (msg.command() == IgfsIpcCommand.READ_BLOCK) {
                        U.intToBytes(req.length(), hdr, 20);
                    }
                    out.write(hdr);
                    if (msg.command() == IgfsIpcCommand.READ_BLOCK) {
                        out.writeLong(req.position());
                    }
                    break;
                }
                case CONTROL_RESPONSE: {
                    out.write(hdr);
                    IgfsControlResponse res = (IgfsControlResponse)msg;
                    res.writeExternal(out);
                    break;
                }
                case MODE_RESOLVER: {
                    out.write(hdr);
                    break;
                }
                default: {
                    assert (false) : "Invalid command: " + (Object)((Object)msg.command());
                    throw new IllegalArgumentException("Failed to marshal message (invalid command): " + (Object)((Object)msg.command()));
                }
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to send message to IGFS data node (is data node up and running?)", e);
        }
    }

    public IgfsMessage unmarshall(IgfsIpcCommand cmd, byte[] hdr, ObjectInput in) throws IgniteCheckedException {
        assert (hdr != null);
        assert (hdr.length == 24);
        try {
            IgfsMessage msg;
            switch (cmd) {
                case HANDSHAKE: {
                    IgfsHandshakeRequest req = new IgfsHandshakeRequest();
                    req.igfsName(U.readString(in));
                    req.logDirectory(U.readString(in));
                    msg = req;
                    break;
                }
                case STATUS: {
                    msg = new IgfsStatusRequest();
                    break;
                }
                case EXISTS: 
                case INFO: 
                case PATH_SUMMARY: 
                case UPDATE: 
                case RENAME: 
                case DELETE: 
                case MAKE_DIRECTORIES: 
                case LIST_PATHS: 
                case LIST_FILES: 
                case AFFINITY: 
                case SET_TIMES: 
                case OPEN_READ: 
                case OPEN_APPEND: 
                case OPEN_CREATE: {
                    IgfsPathControlRequest req = new IgfsPathControlRequest();
                    req.userName(U.readString(in));
                    req.path(this.readPath(in));
                    req.destinationPath(this.readPath(in));
                    req.flag(in.readBoolean());
                    req.colocate(in.readBoolean());
                    req.properties(IgfsUtils.readStringMap(in));
                    if (cmd == IgfsIpcCommand.AFFINITY) {
                        req.start(in.readLong());
                        req.length(in.readLong());
                    } else if (cmd == IgfsIpcCommand.OPEN_CREATE) {
                        req.replication(in.readInt());
                        req.blockSize(in.readLong());
                    } else if (cmd == IgfsIpcCommand.SET_TIMES) {
                        req.accessTime(in.readLong());
                        req.modificationTime(in.readLong());
                    } else if (cmd == IgfsIpcCommand.OPEN_READ && req.flag()) {
                        req.sequentialReadsBeforePrefetch(in.readInt());
                    }
                    msg = req;
                    break;
                }
                case CLOSE: 
                case READ_BLOCK: 
                case WRITE_BLOCK: {
                    IgfsStreamControlRequest req = new IgfsStreamControlRequest();
                    long streamId = U.bytesToLong(hdr, 12);
                    req.streamId(streamId);
                    req.length(U.bytesToInt(hdr, 20));
                    if (cmd == IgfsIpcCommand.READ_BLOCK) {
                        req.position(in.readLong());
                    }
                    msg = req;
                    break;
                }
                case CONTROL_RESPONSE: {
                    IgfsControlResponse res = new IgfsControlResponse();
                    res.readExternal(in);
                    msg = res;
                    break;
                }
                case MODE_RESOLVER: {
                    msg = new IgfsModeResolverRequest();
                    break;
                }
                default: {
                    assert (false) : "Invalid command: " + (Object)((Object)cmd);
                    throw new IllegalArgumentException("Failed to unmarshal message (invalid command): " + (Object)((Object)cmd));
                }
            }
            msg.command(cmd);
            return msg;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IgniteCheckedException("Failed to unmarshal client message: " + (Object)((Object)cmd), e);
        }
    }

    private void writePath(ObjectOutput out, @Nullable IgfsPath path2) throws IOException {
        out.writeBoolean(path2 != null);
        if (path2 != null) {
            path2.writeExternal(out);
        }
    }

    @Nullable
    private IgfsPath readPath(ObjectInput in) throws IOException {
        return in.readBoolean() ? IgfsUtils.readPath(in) : null;
    }
}

