/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import org.jetbrains.annotations.Nullable;

public enum CacheCommand {
    HELP("help"),
    IDLE_VERIFY("idle_verify"),
    LIST("list"),
    VALIDATE_INDEXES("validate_indexes"),
    CONTENTION("contention"),
    DISTRIBUTION("distribution"),
    RESET_LOST_PARTITIONS("reset_lost_partitions");

    private static final CacheCommand[] VALS;
    private final String name;

    private CacheCommand(String name) {
        this.name = name;
    }

    public static CacheCommand of(String text2) {
        for (CacheCommand cmd : CacheCommand.values()) {
            if (!cmd.text().equalsIgnoreCase(text2)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.name;
    }

    @Nullable
    public static CacheCommand fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    static {
        VALS = CacheCommand.values();
    }
}

