/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.jetbrains.annotations.Nullable;

public abstract class GridClientUtils {
    public static void closeQuiet(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static <T> GridClientPredicate<T> contains(final Collection<T> c) {
        return new GridClientPredicate<T>(){

            @Override
            public boolean apply(T t) {
                return c != null && !c.isEmpty() && c.contains(t);
            }
        };
    }

    @Nullable
    public static <T> T first(@Nullable Iterable<? extends T> c) {
        if (c == null) {
            return null;
        }
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <T> Collection<T> applyFilter(Iterable<? extends T> elements2, GridClientPredicate<? super T> ... filters) {
        assert (filters != null);
        LinkedList<T> res = new LinkedList<T>();
        for (T e : elements2) {
            boolean add2 = true;
            for (GridClientPredicate<T> gridClientPredicate : filters) {
                if (gridClientPredicate == null || gridClientPredicate.apply(e)) continue;
                add2 = false;
                break;
            }
            if (!add2) continue;
            res.add(e);
        }
        return res;
    }

    public static boolean restAvailable(GridClientNode node, GridClientProtocol p) {
        return !node.availableAddresses(p, false).isEmpty();
    }

    public static void shutdownNow(Class<?> owner2, ExecutorService exec2, Logger log2) {
        if (exec2 != null) {
            List<Runnable> tasks = exec2.shutdownNow();
            if (!tasks.isEmpty()) {
                log2.warning("Runnable tasks outlived thread pool executor service [owner=" + GridClientUtils.getSimpleName(owner2) + ", tasks=" + tasks + ']');
            }
            try {
                exec2.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                log2.warning("Got interrupted while waiting for executor service to stop.");
                exec2.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String getSimpleName(Class<?> cls) {
        return cls.getSimpleName().isEmpty() ? cls.getName() : cls.getSimpleName();
    }

    public static int safeAbs(int i) {
        return (i = Math.abs(i)) < 0 ? 0 : i;
    }
}

