/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientBinary;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryCursor;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryPager;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.client.thin.Result;
import org.apache.ignite.internal.client.thin.TcpClientCache;
import org.apache.ignite.internal.client.thin.TcpClientChannel;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;

public class TcpIgniteClient
implements IgniteClient {
    private final ReliableChannel ch;
    private final IgniteBinary binary;
    private final ClientBinaryMarshaller marsh;
    private final ClientUtils serDes;

    private TcpIgniteClient(ClientConfiguration cfg) throws ClientException {
        Function<ClientChannelConfiguration, Result<ClientChannel>> chFactory = chCfg -> {
            try {
                return new Result<TcpClientChannel>(new TcpClientChannel((ClientChannelConfiguration)chCfg));
            }
            catch (ClientException e) {
                return new Result(e);
            }
        };
        this.ch = new ReliableChannel(chFactory, cfg);
        this.marsh = new ClientBinaryMarshaller(new ClientBinaryMetadataHandler(), new ClientMarshallerContext());
        this.marsh.setBinaryConfiguration(cfg.getBinaryConfiguration());
        this.serDes = new ClientUtils(this.marsh);
        this.binary = new ClientBinary(this.marsh);
    }

    @Override
    public void close() throws Exception {
        this.ch.close();
    }

    @Override
    public <K, V> ClientCache<K, V> getOrCreateCache(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        this.ch.request(ClientOperation.CACHE_GET_OR_CREATE_WITH_NAME, req -> this.writeString(name, (BinaryOutputStream)req));
        return new TcpClientCache(name, this.ch, this.marsh);
    }

    @Override
    public <K, V> ClientCache<K, V> getOrCreateCache(ClientCacheConfiguration cfg) throws ClientException {
        TcpIgniteClient.ensureCacheConfiguration(cfg);
        this.ch.request(ClientOperation.CACHE_GET_OR_CREATE_WITH_CONFIGURATION, req -> this.serDes.cacheConfiguration(cfg, (BinaryOutputStream)req, this.toClientVersion(this.ch.serverVersion())));
        return new TcpClientCache(cfg.getName(), this.ch, this.marsh);
    }

    @Override
    public <K, V> ClientCache<K, V> cache(String name) {
        TcpIgniteClient.ensureCacheName(name);
        return new TcpClientCache(name, this.ch, this.marsh);
    }

    @Override
    public Collection<String> cacheNames() throws ClientException {
        return this.ch.service(ClientOperation.CACHE_GET_NAMES, res -> Arrays.asList(BinaryUtils.doReadStringArray(res)));
    }

    @Override
    public void destroyCache(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        this.ch.request(ClientOperation.CACHE_DESTROY, req -> req.writeInt(ClientUtils.cacheId(name)));
    }

    @Override
    public <K, V> ClientCache<K, V> createCache(String name) throws ClientException {
        TcpIgniteClient.ensureCacheName(name);
        this.ch.request(ClientOperation.CACHE_CREATE_WITH_NAME, req -> this.writeString(name, (BinaryOutputStream)req));
        return new TcpClientCache(name, this.ch, this.marsh);
    }

    @Override
    public <K, V> ClientCache<K, V> createCache(ClientCacheConfiguration cfg) throws ClientException {
        TcpIgniteClient.ensureCacheConfiguration(cfg);
        this.ch.request(ClientOperation.CACHE_CREATE_WITH_CONFIGURATION, req -> this.serDes.cacheConfiguration(cfg, (BinaryOutputStream)req, this.toClientVersion(this.ch.serverVersion())));
        return new TcpClientCache(cfg.getName(), this.ch, this.marsh);
    }

    private ClientListenerProtocolVersion toClientVersion(ProtocolVersion srvVer) {
        return ClientListenerProtocolVersion.create(srvVer.major(), srvVer.minor(), srvVer.patch());
    }

    @Override
    public IgniteBinary binary() {
        return this.binary;
    }

    @Override
    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        if (qry == null) {
            throw new NullPointerException("qry");
        }
        Consumer<BinaryOutputStream> qryWriter = out -> {
            out.writeInt(0);
            out.writeByte((byte)1);
            this.serDes.write(qry, (BinaryOutputStream)out);
        };
        return new ClientFieldsQueryCursor(new ClientFieldsQueryPager(this.ch, ClientOperation.QUERY_SQL_FIELDS, ClientOperation.QUERY_SQL_FIELDS_CURSOR_GET_PAGE, qryWriter, true, this.marsh));
    }

    public static IgniteClient start(ClientConfiguration cfg) throws ClientException {
        return new TcpIgniteClient(cfg);
    }

    private static void ensureCacheName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Cache name must be specified");
        }
    }

    private static void ensureCacheConfiguration(ClientCacheConfiguration cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("Cache configuration must be specified");
        }
        TcpIgniteClient.ensureCacheName(cfg.getName());
    }

    private void writeString(String s2, BinaryOutputStream out) {
        try (BinaryWriterExImpl w = new BinaryWriterExImpl(this.marsh.context(), out, null, null);){
            w.writeString(s2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readString(BinaryInputStream in) throws BinaryObjectException {
        try (BinaryReaderExImpl r = new BinaryReaderExImpl(this.marsh.context(), in, null, true);){
            String string2 = r.readString();
            return string2;
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
    }

    private class ClientMarshallerContext
    implements MarshallerContext {
        private Map<Integer, String> cache = new ConcurrentHashMap<Integer, String>();

        private ClientMarshallerContext() {
        }

        @Override
        public boolean registerClassName(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
            if (platformId != 0) {
                throw new IllegalArgumentException("platformId");
            }
            boolean res = true;
            if (!this.cache.containsKey(typeId)) {
                try {
                    res = TcpIgniteClient.this.ch.service(ClientOperation.REGISTER_BINARY_TYPE_NAME, req -> {
                        req.writeByte(platformId);
                        req.writeInt(typeId);
                        TcpIgniteClient.this.writeString(clsName, req);
                    }, BinaryInputStream::readBoolean);
                }
                catch (ClientException e) {
                    throw new IgniteCheckedException(e);
                }
                if (res) {
                    this.cache.put(typeId, clsName);
                }
            }
            return res;
        }

        @Override
        public boolean registerClassNameLocally(byte platformId, int typeId, String clsName) {
            if (platformId != 0) {
                throw new IllegalArgumentException("platformId");
            }
            this.cache.put(typeId, clsName);
            return true;
        }

        @Override
        public Class getClass(int typeId, ClassLoader ldr) throws ClassNotFoundException, IgniteCheckedException {
            return U.forName(this.getClassName((byte)0, typeId), ldr, null);
        }

        @Override
        public String getClassName(byte platformId, int typeId) throws ClassNotFoundException, IgniteCheckedException {
            if (platformId != 0) {
                throw new IllegalArgumentException("platformId");
            }
            String clsName = this.cache.get(typeId);
            if (clsName == null) {
                try {
                    clsName = TcpIgniteClient.this.ch.service(ClientOperation.GET_BINARY_TYPE_NAME, req -> {
                        req.writeByte(platformId);
                        req.writeInt(typeId);
                    }, x$0 -> TcpIgniteClient.this.readString(x$0));
                }
                catch (ClientException e) {
                    throw new IgniteCheckedException(e);
                }
            }
            if (clsName == null) {
                throw new ClassNotFoundException(String.format("Unknown type id [%s]", typeId));
            }
            return clsName;
        }

        @Override
        public boolean isSystemType(String typeName) {
            return false;
        }

        @Override
        public IgnitePredicate<String> classNameFilter() {
            return null;
        }

        @Override
        public JdkMarshaller jdkMarshaller() {
            return new JdkMarshaller();
        }
    }

    private class ClientBinaryMetadataHandler
    implements BinaryMetadataHandler {
        private final BinaryMetadataHandler cache = BinaryCachingMetadataHandler.create();

        private ClientBinaryMetadataHandler() {
        }

        @Override
        public void addMeta(int typeId, BinaryType meta, boolean failIfUnregistered) throws BinaryObjectException {
            if (this.cache.metadata(typeId) == null) {
                try {
                    TcpIgniteClient.this.ch.request(ClientOperation.PUT_BINARY_TYPE, req -> TcpIgniteClient.this.serDes.binaryMetadata(((BinaryTypeImpl)meta).metadata(), (BinaryOutputStream)req));
                }
                catch (ClientException e) {
                    throw new BinaryObjectException(e);
                }
            }
            this.cache.addMeta(typeId, meta, failIfUnregistered);
        }

        @Override
        public BinaryType metadata(int typeId) throws BinaryObjectException {
            BinaryMetadata meta0;
            BinaryType meta = this.cache.metadata(typeId);
            if (meta == null && (meta0 = this.metadata0(typeId)) != null) {
                meta = new BinaryTypeImpl(TcpIgniteClient.this.marsh.context(), meta0);
                this.cache.addMeta(typeId, meta, false);
            }
            return meta;
        }

        @Override
        public BinaryMetadata metadata0(int typeId) throws BinaryObjectException {
            BinaryMetadata meta = this.cache.metadata0(typeId);
            if (meta == null) {
                try {
                    meta = TcpIgniteClient.this.ch.service(ClientOperation.GET_BINARY_TYPE, req -> req.writeInt(typeId), res -> {
                        try {
                            return res.readBoolean() ? TcpIgniteClient.this.serDes.binaryMetadata((BinaryInputStream)res) : null;
                        }
                        catch (IOException e) {
                            throw new BinaryObjectException(e);
                        }
                    });
                }
                catch (ClientException e) {
                    throw new BinaryObjectException(e);
                }
            }
            return meta;
        }

        @Override
        public BinaryType metadata(int typeId, int schemaId) throws BinaryObjectException {
            BinaryType meta = this.metadata(typeId);
            return meta != null && ((BinaryTypeImpl)meta).metadata().hasSchema(schemaId) ? meta : null;
        }

        @Override
        public Collection<BinaryType> metadata() throws BinaryObjectException {
            return this.cache.metadata();
        }
    }
}

