/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    private final short major;
    private final short minor;
    private final short patch;

    ProtocolVersion(short major, short minor, short patch2) {
        this.major = major;
        this.minor = minor;
        this.patch = patch2;
    }

    public short major() {
        return this.major;
    }

    public short minor() {
        return this.minor;
    }

    public short patch() {
        return this.patch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProtocolVersion)) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        int res = 11;
        res = 31 * res + this.major;
        res = 31 * res + this.minor;
        res = 31 * res + this.patch;
        return res;
    }

    @Override
    public int compareTo(ProtocolVersion other) {
        int diff2 = this.major - other.major;
        if (diff2 != 0) {
            return diff2;
        }
        diff2 = this.minor - other.minor;
        if (diff2 != 0) {
            return diff2;
        }
        return this.patch - other.patch;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.major, this.minor, this.patch);
    }
}

