/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.internal.A;

@Deprecated
public class GridSslBasicContextFactory
implements GridSslContextFactory {
    public static final String DFLT_STORE_TYPE = "JKS";
    public static final String DFLT_SSL_PROTOCOL = "TLS";
    public static final String DFLT_KEY_ALGORITHM = "SunX509";
    private String proto = "TLS";
    private String keyAlgorithm = "SunX509";
    private String keyStoreType = "JKS";
    private String keyStoreFilePath;
    private char[] keyStorePwd;
    private String trustStoreType = "JKS";
    private String trustStoreFilePath;
    private char[] trustStorePwd;
    private TrustManager[] trustMgrs;

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        A.notNull(keyStoreType, "keyStoreType");
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        A.notNull(trustStoreType, "trustStoreType");
        this.trustStoreType = trustStoreType;
    }

    public String getProtocol() {
        return this.proto;
    }

    public void setProtocol(String proto) {
        A.notNull(proto, "proto");
        this.proto = proto;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        A.notNull(keyAlgorithm, "keyAlgorithm");
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        A.notNull(keyStoreFilePath, "keyStoreFilePath");
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePwd;
    }

    public void setKeyStorePassword(char[] keyStorePwd) {
        A.notNull(keyStorePwd, "keyStorePwd");
        this.keyStorePwd = keyStorePwd;
    }

    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public void setTrustStoreFilePath(String trustStoreFilePath) {
        this.trustStoreFilePath = trustStoreFilePath;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePwd;
    }

    public void setTrustStorePassword(char[] trustStorePwd) {
        this.trustStorePwd = trustStorePwd;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustMgrs;
    }

    public void setTrustManagers(TrustManager ... trustMgrs) {
        this.trustMgrs = trustMgrs;
    }

    public static TrustManager getDisabledTrustManager() {
        return new DisabledX509TrustManager();
    }

    @Override
    public SSLContext createSslContext() throws SSLException {
        this.checkParameters();
        try {
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(this.keyAlgorithm);
            KeyStore keyStore = this.loadKeyStore(this.keyStoreType, this.keyStoreFilePath, this.keyStorePwd);
            keyMgrFactory.init(keyStore, this.keyStorePwd);
            TrustManager[] mgrs = this.trustMgrs;
            if (mgrs == null) {
                TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(this.keyAlgorithm);
                KeyStore trustStore = this.loadKeyStore(this.trustStoreType, this.trustStoreFilePath, this.trustStorePwd);
                trustMgrFactory.init(trustStore);
                mgrs = trustMgrFactory.getTrustManagers();
            }
            SSLContext ctx = SSLContext.getInstance(this.proto);
            ctx.init(keyMgrFactory.getKeyManagers(), mgrs, null);
            return ctx;
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Failed to initialize SSL context " + this.parameters(), e);
        }
    }

    private String parameters() {
        StringBuilder buf = new StringBuilder("[keyStoreType=").append(this.keyStoreType);
        buf.append(", proto=").append(this.proto).append(", keyStoreFile=").append(this.keyStoreFilePath);
        if (this.trustMgrs != null) {
            buf.append(", trustMgrs=").append(Arrays.toString(this.trustMgrs));
        } else {
            buf.append(", trustStoreFile=").append(this.trustStoreFilePath);
        }
        buf.append(']');
        return buf.toString();
    }

    private void checkParameters() throws SSLException {
        assert (this.keyStoreType != null);
        assert (this.proto != null);
        this.checkNullParameter(this.keyStoreFilePath, "keyStoreFilePath");
        this.checkNullParameter(this.keyStorePwd, "keyStorePwd");
        if (this.trustMgrs == null) {
            if (this.trustStoreFilePath == null) {
                throw new SSLException("Failed to initialize SSL context (either trustStoreFilePath or trustManagers must be provided)");
            }
            this.checkNullParameter(this.trustStorePwd, "trustStorePwd");
        }
    }

    private void checkNullParameter(Object param2, String name) throws SSLException {
        if (param2 == null) {
            throw new SSLException("Failed to initialize SSL context (parameter cannot be null): " + name);
        }
    }

    protected InputStream openFileInputStream(String filePath) throws IOException {
        return new FileInputStream(filePath);
    }

    private KeyStore loadKeyStore(String keyStoreType, String storeFilePath, char[] keyStorePwd) throws SSLException {
        InputStream input2 = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            input2 = this.openFileInputStream(storeFilePath);
            keyStore.load(input2, keyStorePwd);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Failed to initialize key store (security exception occurred) [type=" + keyStoreType + ", keyStorePath=" + storeFilePath + ']', e);
        }
        catch (FileNotFoundException e) {
            throw new SSLException("Failed to initialize key store (key store file was not found): [path=" + storeFilePath + ", msg=" + e.getMessage() + ']');
        }
        catch (IOException e) {
            throw new SSLException("Failed to initialize key store (I/O error occurred): " + storeFilePath, e);
        }
        finally {
            if (input2 != null) {
                try {
                    input2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.parameters();
    }

    private static class DisabledX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] CERTS = new X509Certificate[0];

        private DisabledX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return CERTS;
        }
    }
}

