/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.client.message.GridClientResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterResponse;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.internal.U;

class GridTcpRouterNioParser
extends GridTcpRestParser {
    private volatile long rcvCnt;
    private volatile long sndCnt;

    public GridTcpRouterNioParser() {
        super(false);
    }

    @Override
    protected GridClientMessage parseClientMessage(GridNioSession ses, GridTcpRestParser.ParserState state) {
        ++this.rcvCnt;
        return new GridRouterRequest(state.buffer().toByteArray(), state.header().reqId(), state.header().clientId(), state.header().destinationId());
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) throws IOException, IgniteCheckedException {
        ++this.sndCnt;
        if (msg instanceof GridRouterResponse) {
            GridRouterResponse resp = (GridRouterResponse)msg;
            ByteBuffer res = ByteBuffer.allocate(resp.body().length + 45);
            res.put((byte)-112);
            res.putInt(resp.body().length + 40);
            res.putLong(resp.requestId());
            res.put(U.uuidToBytes(resp.clientId()));
            res.put(U.uuidToBytes(resp.destinationId()));
            res.put(resp.body());
            res.flip();
            return res;
        }
        if (msg instanceof GridClientResponse) {
            GridClientMarshaller marsh = this.marshaller(ses);
            GridClientMessage clientMsg = (GridClientMessage)msg;
            ByteBuffer res = marsh.marshal(msg, 45);
            ByteBuffer slice2 = res.slice();
            slice2.put((byte)-112);
            slice2.putInt(res.remaining() - 5);
            slice2.putLong(clientMsg.requestId());
            slice2.put(U.uuidToBytes(clientMsg.clientId()));
            slice2.put(U.uuidToBytes(clientMsg.destinationId()));
            return res;
        }
        if (msg instanceof GridClientPingPacket || msg instanceof GridClientHandshakeResponse) {
            return super.encode(ses, msg);
        }
        throw new IgniteCheckedException("Unsupported message: " + msg);
    }

    public long getReceivedCount() {
        return this.rcvCnt;
    }

    public long getSendCount() {
        return this.sndCnt;
    }
}

