/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router.impl;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.UUID;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.router.GridTcpRouter;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.client.router.GridTcpRouterMBean;
import org.apache.ignite.internal.client.router.impl.GridRouterClientImpl;
import org.apache.ignite.internal.client.router.impl.GridTcpRouterNioListenerOsImpl;
import org.apache.ignite.internal.client.router.impl.GridTcpRouterNioParser;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.logger.java.JavaLogger;
import org.jetbrains.annotations.Nullable;

public class GridTcpRouterImpl
implements GridTcpRouter,
GridTcpRouterMBean,
LifecycleAware {
    private final UUID id = UUID.randomUUID();
    private final GridTcpRouterConfiguration cfg;
    private final IgniteLogger log;
    private GridNioServer<GridClientMessage> srv;
    private GridRouterClientImpl client;
    private ObjectName mbeanName;
    private volatile GridTcpRouterNioParser parser;
    private volatile String bindHost;
    private volatile int bindPort;

    public GridTcpRouterImpl(GridTcpRouterConfiguration cfg) {
        this.cfg = cfg;
        this.log = cfg.getLogger() != null ? cfg.getLogger().getLogger(this.getClass()) : new JavaLogger().getLogger(this.getClass());
    }

    @Override
    public void start() throws IgniteException {
        int port;
        SSLContext sslCtx;
        InetAddress hostAddr;
        try {
            this.client = this.createClient(this.cfg);
        }
        catch (GridClientException e) {
            throw new IgniteException("Failed to initialise embedded client.", e);
        }
        GridTcpRouterNioListenerOsImpl lsnr = new GridTcpRouterNioListenerOsImpl(this.log, this.client);
        this.parser = new GridTcpRouterNioParser();
        try {
            hostAddr = InetAddress.getByName(this.cfg.getHost());
        }
        catch (UnknownHostException e) {
            throw new IgniteException("Failed to resolve grid address for configured host: " + this.cfg.getHost(), e);
        }
        try {
            GridSslContextFactory sslCtxFactory = this.cfg.getSslContextFactory();
            sslCtx = sslCtxFactory == null ? null : sslCtxFactory.createSslContext();
        }
        catch (SSLException e) {
            throw new IgniteException("Failed to create SSL context.", e);
        }
        int last2 = port + this.cfg.getPortRange();
        for (port = this.cfg.getPort(); port <= last2; ++port) {
            if (this.startTcpServer(hostAddr, port, lsnr, this.parser, this.cfg.isNoDelay(), sslCtx, this.cfg.isSslClientAuth(), this.cfg.isSslClientAuth())) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("TCP router successfully started for endpoint: " + hostAddr.getHostAddress() + ":" + port);
                }
                this.bindPort = port;
                this.bindHost = hostAddr.getHostName();
                break;
            }
            U.warn(this.log, "TCP REST router failed to start on endpoint: " + hostAddr.getHostAddress() + ":" + port + ". Will try next port within allowed port range.");
        }
        if (this.bindPort == 0) {
            throw new IgniteException("Failed to bind TCP router server (possibly all ports in range are in use) [firstPort=" + this.cfg.getPort() + ", lastPort=" + (this.cfg.getPort() + this.cfg.getPortRange()) + ", addr=" + hostAddr + ']');
        }
        this.registerMBean();
    }

    @Override
    public void stop() {
        if (this.srv != null) {
            this.srv.stop();
        }
        if (this.client != null) {
            this.client.stop(true);
        }
        this.unregisterMBean();
        if (this.log.isInfoEnabled()) {
            this.log.info("TCP router successfully stopped.");
        }
    }

    private void registerMBean() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            ObjectName objName = U.registerMBean(ManagementFactory.getPlatformMBeanServer(), "Router", "TCP Router " + this.id, this.getClass().getSimpleName(), this, GridTcpRouterMBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered MBean: " + objName);
            }
            this.mbeanName = objName;
        }
        catch (JMException e) {
            U.error(this.log, "Failed to register MBean.", e);
        }
    }

    private void unregisterMBean() {
        if (this.mbeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered MBean: " + this.mbeanName);
            }
        }
        catch (JMException e) {
            U.error(this.log, "Failed to unregister MBean.", e);
        }
    }

    private boolean startTcpServer(InetAddress hostAddr, int port, GridNioServerListener<GridClientMessage> lsnr, GridNioParser parser, boolean tcpNoDelay, @Nullable SSLContext sslCtx, boolean wantClientAuth, boolean needClientAuth) {
        try {
            GridNioFilter[] filters;
            GridNioCodecFilter codec = new GridNioCodecFilter(parser, this.log, false);
            String igniteInstanceName = "router-" + this.id;
            if (sslCtx != null) {
                GridNioSslFilter sslFilter = new GridNioSslFilter(sslCtx, false, ByteOrder.nativeOrder(), this.log);
                sslFilter.wantClientAuth(wantClientAuth);
                sslFilter.needClientAuth(needClientAuth);
                filters = new GridNioFilter[]{codec, sslFilter};
            } else {
                filters = new GridNioFilter[]{codec};
            }
            this.srv = GridNioServer.builder().address(hostAddr).port(port).listener(lsnr).logger(this.log).selectorCount(Runtime.getRuntime().availableProcessors()).igniteInstanceName(igniteInstanceName).serverName("router").tcpNoDelay(tcpNoDelay).directBuffer(false).byteOrder(ByteOrder.nativeOrder()).socketSendBufferSize(0).socketReceiveBufferSize(0).sendQueueLimit(0).filters(filters).idleTimeout(this.cfg.getIdleTimeout()).build();
            this.srv.start();
            return true;
        }
        catch (IgniteCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to start TCP router protocol on port " + port + ": " + e.getMessage());
            }
            this.srv = null;
            return false;
        }
    }

    private GridRouterClientImpl createClient(GridTcpRouterConfiguration routerCfg) throws GridClientException {
        UUID clientId = UUID.randomUUID();
        return new GridRouterClientImpl(clientId, routerCfg);
    }

    @Override
    public String getHost() {
        return this.bindHost;
    }

    @Override
    public int getPort() {
        return this.bindPort;
    }

    @Override
    public boolean isSslEnabled() {
        return this.cfg.getSslContextFactory() != null;
    }

    @Override
    public boolean isSslClientAuth() {
        return this.cfg.isSslClientAuth();
    }

    @Override
    public Collection<String> getServers() {
        return this.cfg.getServers();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public GridTcpRouterConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public long getReceivedCount() {
        return this.parser != null ? this.parser.getReceivedCount() : 0L;
    }

    @Override
    public long getSendCount() {
        return this.parser != null ? this.parser.getSendCount() : 0L;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridTcpRouterImpl that = (GridTcpRouterImpl)o;
        return this.id.equals(that.id);
    }
}

