/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.marshaller.optimized;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

public class GridClientOptimizedMarshaller
implements GridClientMarshaller {
    public static final byte ID = 1;
    protected final OptimizedMarshaller opMarsh = new OptimizedMarshaller();

    public GridClientOptimizedMarshaller() {
        this.opMarsh.setContext(new ClientMarshallerContext());
    }

    public GridClientOptimizedMarshaller(@Nullable List<PluginProvider> plugins) {
        this.opMarsh.setContext(new ClientMarshallerContext(plugins));
    }

    public GridClientOptimizedMarshaller(boolean requireSer, int poolSize) throws IOException {
        this.opMarsh.setContext(new ClientMarshallerContext());
        this.opMarsh.setRequireSerializable(requireSer);
        this.opMarsh.setPoolSize(poolSize);
    }

    @Override
    public ByteBuffer marshal(Object obj, int off) throws IOException {
        try {
            if (!(obj instanceof GridClientMessage)) {
                throw new IOException("Message serialization of given type is not supported: " + obj.getClass().getName());
            }
            byte[] bytes2 = U.marshal(this.opMarsh, obj);
            ByteBuffer buf = ByteBuffer.allocate(off + bytes2.length);
            buf.position(off);
            buf.put(bytes2);
            buf.flip();
            return buf;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T unmarshal(byte[] bytes2) throws IOException {
        try {
            return U.unmarshal((Marshaller)this.opMarsh, bytes2, null);
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    private static class ClientMarshallerContext
    extends MarshallerContextImpl {
        public ClientMarshallerContext() {
            super(null, null);
        }

        public ClientMarshallerContext(@Nullable List<PluginProvider> plugins) {
            super(plugins, null);
        }
    }
}

