/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.marshaller.jdk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.lang.IgnitePredicate;

public class GridClientJdkMarshaller
implements GridClientMarshaller {
    public static final byte ID = 2;
    private final IgnitePredicate<String> clsFilter;

    public GridClientJdkMarshaller() {
        this(null);
    }

    public GridClientJdkMarshaller(IgnitePredicate<String> clsFilter) {
        this.clsFilter = clsFilter;
    }

    @Override
    public ByteBuffer marshal(Object obj, int off) throws IOException {
        GridByteArrayOutputStream bOut = new GridByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bOut);
        out.writeObject(obj);
        out.flush();
        ByteBuffer buf = ByteBuffer.allocate(off + bOut.size());
        buf.position(off);
        buf.put(bOut.internalArray(), 0, bOut.size());
        buf.flip();
        return buf;
    }

    @Override
    public <T> T unmarshal(byte[] bytes2) throws IOException {
        ByteArrayInputStream tmp = new ByteArrayInputStream(bytes2);
        ClientJdkInputStream in = new ClientJdkInputStream(tmp, this.clsFilter);
        try {
            return (T)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to unmarshal target object: " + e.getMessage(), e);
        }
    }

    private static class ClientJdkInputStream
    extends ObjectInputStream {
        private final IgnitePredicate<String> clsFilter;

        public ClientJdkInputStream(InputStream in, IgnitePredicate<String> clsFilter) throws IOException {
            super(in);
            this.clsFilter = clsFilter;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String clsName = desc.getName();
            if (this.clsFilter != null && !this.clsFilter.apply(clsName)) {
                throw new RuntimeException("Deserialization of class " + clsName + " is disallowed.");
            }
            return super.resolveClass(desc);
        }
    }
}

