/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl.connection;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.impl.GridClientNodeImpl;
import org.apache.ignite.internal.client.impl.GridClientThreadFactory;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClientTopology {
    private static final Logger log = Logger.getLogger(GridClientTopology.class.getName());
    private Map<UUID, GridClientNodeImpl> nodes = Collections.emptyMap();
    private GridClientException lastError;
    private final String routers;
    private final Set<InetSocketAddress> routerAddrs;
    private final Collection<String> macsCache;
    private final GridClientProtocol prot;
    private final boolean metricsCache;
    private final boolean attrCache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Collection<GridClientTopologyListener> topLsnrs = new ConcurrentLinkedQueue<GridClientTopologyListener>();
    private final ExecutorService exec = Executors.newSingleThreadExecutor(new GridClientThreadFactory("top-lsnr", true));

    public GridClientTopology(GridClientConfiguration cfg) {
        this.metricsCache = cfg.isEnableMetricsCache();
        this.attrCache = cfg.isEnableAttributesCache();
        this.prot = cfg.getProtocol();
        if (!cfg.getRouters().isEmpty() && cfg.getServers().isEmpty()) {
            this.routers = cfg.getRouters().toString();
            this.routerAddrs = U.newHashSet(cfg.getRouters().size());
            for (String router : cfg.getRouters()) {
                int portIdx = router.lastIndexOf(":");
                if (portIdx <= 0) continue;
                String hostName = router.substring(0, portIdx);
                try {
                    int port = Integer.parseInt(router.substring(portIdx + 1));
                    InetSocketAddress inetSockAddr = new InetSocketAddress(hostName, port);
                    this.routerAddrs.add(inetSockAddr);
                }
                catch (Exception exception) {}
            }
        } else {
            this.routers = null;
            this.routerAddrs = Collections.emptySet();
        }
        this.macsCache = U.allLocalMACs();
    }

    public void addTopologyListener(GridClientTopologyListener lsnr) {
        this.topLsnrs.add(lsnr);
    }

    public void removeTopologyListener(GridClientTopologyListener lsnr) {
        this.topLsnrs.remove(lsnr);
    }

    public Collection<GridClientTopologyListener> topologyListeners() {
        return Collections.unmodifiableCollection(this.topLsnrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridClientNode updateNode(GridClientNodeImpl node) {
        this.lock.writeLock().lock();
        try {
            boolean newNode = !this.nodes.containsKey(node.nodeId());
            GridClientNodeImpl preparedNode = this.prepareNode(node);
            if (newNode || this.metricsCache || this.attrCache) {
                HashMap<UUID, GridClientNodeImpl> updatedTop = new HashMap<UUID, GridClientNodeImpl>(this.nodes);
                updatedTop.put(node.nodeId(), preparedNode);
                this.nodes = updatedTop;
                this.lastError = null;
            }
            if (newNode) {
                this.notifyEvents(Collections.singletonList(new TopologyEvent(true, preparedNode)));
            }
            GridClientNodeImpl gridClientNodeImpl = preparedNode;
            return gridClientNodeImpl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends GridClientNode> updateTopology(Collection<GridClientNodeImpl> nodeList) {
        LinkedList<TopologyEvent> evts = new LinkedList<TopologyEvent>();
        this.lock.writeLock().lock();
        try {
            HashMap<UUID, GridClientNodeImpl> updated2 = new HashMap<UUID, GridClientNodeImpl>();
            Collection<GridClientNodeImpl> preparedNodes = F.transform(nodeList, new C1<GridClientNodeImpl, GridClientNodeImpl>(){

                @Override
                public GridClientNodeImpl apply(GridClientNodeImpl e) {
                    return GridClientTopology.this.prepareNode(e);
                }
            });
            for (GridClientNodeImpl gridClientNodeImpl : preparedNodes) {
                updated2.put(gridClientNodeImpl.nodeId(), gridClientNodeImpl);
                if (this.nodes.containsKey(gridClientNodeImpl.nodeId())) continue;
                evts.add(new TopologyEvent(true, gridClientNodeImpl));
            }
            for (Map.Entry entry2 : this.nodes.entrySet()) {
                if (updated2.containsKey(entry2.getKey())) continue;
                evts.add(new TopologyEvent(false, (GridClientNode)entry2.getValue()));
            }
            this.nodes = updated2;
            this.lastError = null;
            if (!evts.isEmpty()) {
                this.notifyEvents(evts);
            }
            Collection<GridClientNodeImpl> collection = preparedNodes;
            return collection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(GridClientException cause) {
        this.lock.writeLock().lock();
        try {
            this.lastError = cause;
            for (GridClientNode gridClientNode : this.nodes.values()) {
                this.notifyEvents(Collections.singletonList(new TopologyEvent(false, gridClientNode)));
            }
            this.nodes = Collections.emptyMap();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeFailed(UUID nodeId) {
        this.lock.writeLock().lock();
        try {
            boolean nodeDeleted = this.nodes.containsKey(nodeId);
            GridClientNode deleted = null;
            if (nodeDeleted) {
                HashMap<UUID, GridClientNodeImpl> updatedTop = new HashMap<UUID, GridClientNodeImpl>(this.nodes);
                deleted = (GridClientNode)updatedTop.remove(nodeId);
                this.nodes = updatedTop;
            }
            if (nodeDeleted) {
                this.notifyEvents(Collections.singletonList(new TopologyEvent(false, deleted)));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public GridClientNode node(UUID id) throws GridClientException {
        assert (id != null);
        this.lock.readLock().lock();
        try {
            if (this.lastError != null) {
                throw new GridClientDisconnectedException("Topology is failed [protocol=" + (Object)((Object)this.prot) + ", routers=" + this.routers + ']', this.lastError);
            }
            GridClientNode gridClientNode = this.nodes.get(id);
            return gridClientNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridClientNode> nodes(Iterable<UUID> ids) throws GridClientException {
        assert (ids != null);
        LinkedList<GridClientNodeImpl> res = new LinkedList<GridClientNodeImpl>();
        this.lock.readLock().lock();
        try {
            if (this.lastError != null) {
                throw new GridClientDisconnectedException("Latest topology update failed.", this.lastError);
            }
            for (UUID id : ids) {
                GridClientNodeImpl node = this.nodes.get(id);
                if (node == null) continue;
                res.add(node);
            }
            LinkedList<GridClientNodeImpl> linkedList = res;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<GridClientNodeImpl> nodes() throws GridClientException {
        this.lock.readLock().lock();
        try {
            if (this.lastError != null) {
                throw new GridClientDisconnectedException("Latest topology update failed.", this.lastError);
            }
            Collection<GridClientNodeImpl> collection = Collections.unmodifiableCollection(this.nodes.values());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean failed() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.lastError != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void shutdown() {
        GridClientUtils.shutdownNow(GridClientTopology.class, this.exec, log);
    }

    private GridClientNodeImpl prepareNode(GridClientNodeImpl node) {
        boolean noAttrsAndMetrics;
        boolean bl = noAttrsAndMetrics = this.metricsCache && this.attrCache || node.attributes().isEmpty() && node.metrics() == null;
        if (noAttrsAndMetrics && this.routerAddrs.isEmpty() && node.connectable()) {
            return node;
        }
        GridClientNodeImpl.Builder nodeBuilder = GridClientNodeImpl.builder(node, !this.attrCache, !this.metricsCache);
        for (InetSocketAddress addr : node.availableAddresses(this.prot, true)) {
            boolean reachable;
            boolean router = this.routerAddrs.isEmpty() || this.routerAddrs.contains(addr);
            boolean bl2 = reachable = noAttrsAndMetrics || !addr.getAddress().isLoopbackAddress() || F.containsAny(this.macsCache, ((String)node.attribute("org.apache.ignite.macs")).split(", "));
            if (!router || !reachable) continue;
            nodeBuilder.connectable(true);
            break;
        }
        return nodeBuilder.build();
    }

    private void notifyEvents(final Iterable<TopologyEvent> evts) {
        try {
            this.exec.execute(new Runnable(){

                @Override
                public void run() {
                    for (TopologyEvent evt : evts) {
                        if (evt.added()) {
                            for (GridClientTopologyListener lsnr : GridClientTopology.this.topLsnrs) {
                                lsnr.onNodeAdded(evt.node());
                            }
                            continue;
                        }
                        for (GridClientTopologyListener lsnr : GridClientTopology.this.topLsnrs) {
                            lsnr.onNodeRemoved(evt.node());
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            log.warning("Unable to notify event listeners on topology change since client is shutting down: " + e.getMessage());
        }
    }

    private static class TopologyEvent {
        private boolean added;
        private GridClientNode node;

        private TopologyEvent(boolean added, GridClientNode node) {
            this.added = added;
            this.node = node;
        }

        private boolean added() {
            return this.added;
        }

        private GridClientNode node() {
            return this.node;
        }
    }
}

