/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.balancer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.balancer.GridClientBalancerAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClientRoundRobinBalancer
extends GridClientBalancerAdapter
implements GridClientTopologyListener {
    private Lock lock = new ReentrantLock();
    private LinkedList<UUID> nodeQueue = new LinkedList();

    @Override
    public GridClientNode balancedNode(Collection<? extends GridClientNode> nodes2) throws GridClientException {
        Collection<GridClientNode> direct;
        int directSize;
        assert (!nodes2.isEmpty());
        if (this.isPreferDirectNodes() && (directSize = (direct = GridClientRoundRobinBalancer.selectDirectNodes(nodes2)).size()) > 0 && directSize < nodes2.size()) {
            nodes2 = direct;
        }
        HashMap<UUID, GridClientNode> lookup2 = U.newHashMap(nodes2.size());
        for (GridClientNode gridClientNode : nodes2) {
            lookup2.put(gridClientNode.nodeId(), gridClientNode);
        }
        this.lock.lock();
        try {
            GridClientNode balanced = null;
            Iterator iterator2 = this.nodeQueue.iterator();
            while (iterator2.hasNext()) {
                UUID nodeId = (UUID)iterator2.next();
                balanced = (GridClientNode)lookup2.get(nodeId);
                if (balanced == null) continue;
                iterator2.remove();
                break;
            }
            if (balanced != null) {
                this.nodeQueue.addLast(balanced.nodeId());
                GridClientNode gridClientNode = balanced;
                return gridClientNode;
            }
            throw new GridClientException("Passed nodes doesn't present in topology [nodes=" + nodes2 + ", top=" + this.nodeQueue);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onNodeAdded(GridClientNode node) {
        this.lock.lock();
        try {
            this.nodeQueue.addFirst(node.nodeId());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onNodeRemoved(GridClientNode node) {
        this.lock.lock();
        try {
            this.nodeQueue.remove(node.nodeId());
        }
        finally {
            this.lock.unlock();
        }
    }
}

