/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryAbstractLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.util.typedef.internal.U;

class BinaryLazySet
extends BinaryAbstractLazyValue {
    private final int off;

    BinaryLazySet(BinaryBuilderReader reader, int size2) {
        super(reader, reader.position() - 1);
        this.off = reader.position() - 1 - 4 - 1;
        assert (size2 >= 0);
        for (int i = 0; i < size2; ++i) {
            reader.skipValue();
        }
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        if (this.val == null) {
            int size2 = this.reader.readIntPositioned(this.off + 1);
            int hdrSize = 6;
            writer.write(this.reader.array(), this.off, hdrSize);
            this.reader.position(this.off + hdrSize);
            for (int i = 0; i < size2; ++i) {
                Object o = this.reader.parseValue();
                ctx.writeValue(writer, o);
            }
        } else {
            Collection c = (Collection)this.val;
            writer.writeByte((byte)24);
            writer.writeInt(c.size());
            byte colType = this.reader.array()[this.off + 1 + 4];
            writer.writeByte(colType);
            for (Object o : c) {
                ctx.writeValue(writer, o);
            }
        }
    }

    @Override
    protected Object init() {
        int size2 = this.reader.readIntPositioned(this.off + 1);
        this.reader.position(this.off + 1 + 4 + 1);
        LinkedHashSet res = U.newLinkedHashSet(size2);
        for (int i = 0; i < size2; ++i) {
            res.add(BinaryUtils.unwrapLazy(this.reader.parseValue()));
        }
        return res;
    }
}

