/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryPositionReadable;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryAbstractLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryBuilderEnum;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.binary.builder.BinaryEnumArrayLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryLazyArrayList;
import org.apache.ignite.internal.binary.builder.BinaryLazyLinkedList;
import org.apache.ignite.internal.binary.builder.BinaryLazyMap;
import org.apache.ignite.internal.binary.builder.BinaryLazySet;
import org.apache.ignite.internal.binary.builder.BinaryLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryModifiableLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryObjectArrayLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.binary.builder.BinaryPlainBinaryObject;
import org.apache.ignite.internal.binary.builder.BinaryPlainLazyValue;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BinaryBuilderReader
implements BinaryPositionReadable {
    private final BinaryContext ctx;
    private final byte[] arr;
    private final BinaryReaderExImpl reader;
    private final Map<Integer, BinaryObjectBuilderImpl> objMap;
    private int pos;

    BinaryBuilderReader(BinaryObjectImpl objImpl) {
        this.ctx = objImpl.context();
        this.arr = objImpl.array();
        this.pos = objImpl.start();
        this.reader = new BinaryReaderExImpl(this.ctx, BinaryHeapInputStream.create(this.arr, this.pos), this.ctx.configuration().getClassLoader(), false);
        this.objMap = new HashMap<Integer, BinaryObjectBuilderImpl>();
    }

    BinaryBuilderReader(BinaryBuilderReader other, int start) {
        this.ctx = other.ctx;
        this.arr = other.arr;
        this.pos = start;
        this.reader = new BinaryReaderExImpl(this.ctx, BinaryHeapInputStream.create(this.arr, start), null, other.reader.handles(), false);
        this.objMap = other.objMap;
    }

    public BinaryContext binaryContext() {
        return this.ctx;
    }

    public void registerObject(BinaryObjectBuilderImpl obj) {
        this.objMap.put(obj.start(), obj);
    }

    public BinarySchema schema() {
        return this.reader.getOrCreateSchema();
    }

    public int readInt() {
        int res = this.readInt(0);
        this.pos += 4;
        return res;
    }

    public byte readByte() {
        return this.arr[this.pos++];
    }

    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    public byte readByte(int off) {
        return this.arr[this.pos + off];
    }

    public int readInt(int off) {
        return BinaryPrimitives.readInt(this.arr, this.pos + off);
    }

    @Override
    public byte readBytePositioned(int pos) {
        return BinaryPrimitives.readByte(this.arr, pos);
    }

    @Override
    public short readShortPositioned(int pos) {
        return BinaryPrimitives.readShort(this.arr, pos);
    }

    @Override
    public int readIntPositioned(int pos) {
        return BinaryPrimitives.readInt(this.arr, pos);
    }

    public int readLength() {
        return BinaryPrimitives.readInt(this.arr, this.pos);
    }

    public int readStringLength() {
        return BinaryPrimitives.readInt(this.arr, this.pos);
    }

    public String readString() {
        byte flag = this.readByte();
        if (flag == 101) {
            return null;
        }
        if (flag != 9) {
            throw new BinaryObjectException("Failed to deserialize String.");
        }
        int len = this.readInt();
        String str = new String(this.arr, this.pos, len, StandardCharsets.UTF_8);
        this.pos += len;
        return str;
    }

    public void skipValue() {
        int len;
        byte type = this.arr[this.pos++];
        switch (type) {
            case 101: {
                return;
            }
            case 103: {
                this.pos += this.readInt(11) - 1;
                return;
            }
            case 1: 
            case 8: {
                len = 1;
                break;
            }
            case 2: 
            case 7: {
                len = 2;
                break;
            }
            case 3: 
            case 5: 
            case 102: {
                len = 4;
                break;
            }
            case 28: {
                len = 8;
                break;
            }
            case 4: 
            case 6: {
                len = 8;
                break;
            }
            case 12: 
            case 19: {
                len = 4 + this.readLength();
                break;
            }
            case 9: {
                len = 4 + this.readStringLength();
                break;
            }
            case 30: {
                len = 8 + this.readInt(4);
                break;
            }
            case 10: {
                len = 16;
                break;
            }
            case 11: {
                len = 8;
                break;
            }
            case 33: {
                len = 12;
                break;
            }
            case 36: {
                len = 8;
                break;
            }
            case 13: 
            case 18: {
                len = 4 + this.readLength() * 2;
                break;
            }
            case 14: 
            case 16: {
                len = 4 + this.readLength() * 4;
                break;
            }
            case 15: 
            case 17: {
                len = 4 + this.readLength() * 8;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 34: 
            case 37: {
                int size2 = this.readInt();
                for (int i = 0; i < size2; ++i) {
                    this.skipValue();
                }
                return;
            }
            case 24: {
                int size3 = this.readInt();
                ++this.pos;
                for (int i = 0; i < size3; ++i) {
                    this.skipValue();
                }
                return;
            }
            case 25: {
                int size4 = this.readInt();
                ++this.pos;
                for (int i = 0; i < size4; ++i) {
                    this.skipValue();
                    this.skipValue();
                }
                return;
            }
            case 27: {
                len = this.readInt() + 4;
                break;
            }
            default: {
                throw new BinaryObjectException("Invalid flag value: " + type);
            }
        }
        this.pos += len;
    }

    public Object getValueQuickly(int pos, int len) {
        byte type = this.arr[pos];
        switch (type) {
            case 101: {
                return null;
            }
            case 102: {
                int objStart = pos - this.readIntPositioned(pos + 1);
                BinaryObjectBuilderImpl res = this.objMap.get(objStart);
                if (res == null) {
                    res = new BinaryObjectBuilderImpl(new BinaryBuilderReader(this, objStart), objStart);
                    this.objMap.put(objStart, res);
                }
                return res;
            }
            case 103: {
                BinaryObjectBuilderImpl res = this.objMap.get(pos);
                if (res == null) {
                    res = new BinaryObjectBuilderImpl(new BinaryBuilderReader(this, pos), pos);
                    this.objMap.put(pos, res);
                }
                return res;
            }
            case 1: {
                return this.arr[pos + 1];
            }
            case 2: {
                return BinaryPrimitives.readShort(this.arr, pos + 1);
            }
            case 3: {
                return BinaryPrimitives.readInt(this.arr, pos + 1);
            }
            case 4: {
                return BinaryPrimitives.readLong(this.arr, pos + 1);
            }
            case 5: {
                return Float.valueOf(BinaryPrimitives.readFloat(this.arr, pos + 1));
            }
            case 6: {
                return BinaryPrimitives.readDouble(this.arr, pos + 1);
            }
            case 7: {
                return Character.valueOf(BinaryPrimitives.readChar(this.arr, pos + 1));
            }
            case 8: {
                return this.arr[pos + 1] != 0;
            }
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 33: 
            case 36: {
                return new BinaryPlainLazyValue(this, pos, len);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 34: 
            case 37: {
                return new LazyCollection(pos);
            }
            case 28: {
                if (len == 1) {
                    assert (this.readByte(pos) == 101);
                    return null;
                }
                int mark2 = this.position();
                this.position(pos + 1);
                BinaryBuilderEnum builderEnum = new BinaryBuilderEnum(this);
                this.position(mark2);
                return builderEnum;
            }
            case 27: {
                int size2 = this.readIntPositioned(pos + 1);
                int start = this.readIntPositioned(pos + 4 + size2);
                BinaryObjectImpl binaryObj = new BinaryObjectImpl(this.ctx, this.arr, pos + 4 + start);
                return new BinaryPlainBinaryObject(binaryObj);
            }
            case -2: {
                BinaryHeapInputStream bin = BinaryHeapInputStream.create(this.arr, pos + 1);
                Object obj = BinaryUtils.doReadOptimized(bin, this.ctx, U.resolveClassLoader(this.ctx.configuration()));
                return obj;
            }
        }
        throw new BinaryObjectException("Invalid flag value: " + type);
    }

    public Object parseValue() {
        int plainLazyValLen;
        int valPos = this.pos;
        byte type = this.arr[this.pos++];
        boolean modifiableLazyVal = false;
        switch (type) {
            case 101: {
                return null;
            }
            case 102: {
                int objStart = this.pos - 1 - this.readInt();
                BinaryObjectBuilderImpl res = this.objMap.get(objStart);
                if (res == null) {
                    res = new BinaryObjectBuilderImpl(new BinaryBuilderReader(this, objStart), objStart);
                    this.objMap.put(objStart, res);
                }
                return res;
            }
            case 103: {
                --this.pos;
                BinaryObjectBuilderImpl res = this.objMap.get(this.pos);
                if (res == null) {
                    res = new BinaryObjectBuilderImpl(new BinaryBuilderReader(this, this.pos), this.pos);
                    this.objMap.put(this.pos, res);
                }
                this.pos += this.readInt(12);
                return res;
            }
            case 1: {
                return this.arr[this.pos++];
            }
            case 2: {
                Short res = BinaryPrimitives.readShort(this.arr, this.pos);
                this.pos += 2;
                return res;
            }
            case 3: {
                return this.readInt();
            }
            case 4: {
                plainLazyValLen = 8;
                break;
            }
            case 5: {
                plainLazyValLen = 4;
                break;
            }
            case 6: {
                plainLazyValLen = 8;
                break;
            }
            case 7: {
                plainLazyValLen = 2;
                break;
            }
            case 8: {
                return this.arr[this.pos++] != 0;
            }
            case 30: {
                plainLazyValLen = 8 + this.readInt(4);
                break;
            }
            case 9: {
                plainLazyValLen = 4 + this.readStringLength();
                break;
            }
            case 10: {
                plainLazyValLen = 16;
                break;
            }
            case 11: {
                plainLazyValLen = 8;
                break;
            }
            case 33: {
                plainLazyValLen = 12;
                break;
            }
            case 36: {
                plainLazyValLen = 8;
                break;
            }
            case 12: {
                plainLazyValLen = 4 + this.readLength();
                modifiableLazyVal = true;
                break;
            }
            case 13: {
                plainLazyValLen = 4 + this.readLength() * 2;
                modifiableLazyVal = true;
                break;
            }
            case 14: {
                plainLazyValLen = 4 + this.readLength() * 4;
                modifiableLazyVal = true;
                break;
            }
            case 15: {
                plainLazyValLen = 4 + this.readLength() * 8;
                modifiableLazyVal = true;
                break;
            }
            case 16: {
                plainLazyValLen = 4 + this.readLength() * 4;
                modifiableLazyVal = true;
                break;
            }
            case 17: {
                plainLazyValLen = 4 + this.readLength() * 8;
                modifiableLazyVal = true;
                break;
            }
            case 18: {
                plainLazyValLen = 4 + this.readLength() * 2;
                modifiableLazyVal = true;
                break;
            }
            case 19: {
                plainLazyValLen = 4 + this.readLength();
                modifiableLazyVal = true;
                break;
            }
            case 23: {
                return new BinaryObjectArrayLazyValue(this);
            }
            case 22: {
                int size2 = this.readInt();
                Date[] res = new Date[size2];
                for (int i = 0; i < res.length; ++i) {
                    byte flag;
                    if ((flag = this.arr[this.pos++]) == 101) continue;
                    if (flag != 11) {
                        throw new BinaryObjectException("Invalid flag value: " + flag);
                    }
                    long time = BinaryPrimitives.readLong(this.arr, this.pos);
                    this.pos += 8;
                    res[i] = new Date(time);
                }
                return res;
            }
            case 34: {
                int size3 = this.readInt();
                Timestamp[] res = new Timestamp[size3];
                for (int i = 0; i < res.length; ++i) {
                    byte flag;
                    if ((flag = this.arr[this.pos++]) == 101) continue;
                    if (flag != 33) {
                        throw new BinaryObjectException("Invalid flag value: " + flag);
                    }
                    long time = BinaryPrimitives.readLong(this.arr, this.pos);
                    this.pos += 8;
                    int nano = BinaryPrimitives.readInt(this.arr, this.pos);
                    this.pos += 4;
                    Timestamp ts = new Timestamp(time);
                    ts.setNanos(ts.getNanos() + nano);
                    res[i] = ts;
                }
                return res;
            }
            case 37: {
                int size4 = this.readInt();
                Time[] res = new Time[size4];
                for (int i = 0; i < res.length; ++i) {
                    byte flag;
                    if ((flag = this.arr[this.pos++]) == 101) continue;
                    if (flag != 36) {
                        throw new BinaryObjectException("Invalid flag value: " + flag);
                    }
                    long time = BinaryPrimitives.readLong(this.arr, this.pos);
                    this.pos += 8;
                    res[i] = new Time(time);
                }
                return res;
            }
            case 20: 
            case 21: 
            case 31: {
                int size5 = this.readInt();
                for (int i = 0; i < size5; ++i) {
                    byte flag;
                    if ((flag = this.arr[this.pos++]) == 10) {
                        this.pos += 16;
                        continue;
                    }
                    if (flag == 9) {
                        this.pos += 4 + this.readStringLength();
                        continue;
                    }
                    if (flag == 30) {
                        this.pos += 4;
                        this.pos += 4 + this.readLength();
                        continue;
                    }
                    assert (flag == 101);
                }
                return new BinaryModifiableLazyValue(this, valPos, this.pos - valPos);
            }
            case 24: {
                int size6 = this.readInt();
                byte colType = this.arr[this.pos++];
                switch (colType) {
                    case 0: 
                    case 1: {
                        return new BinaryLazyArrayList(this, size6);
                    }
                    case 2: {
                        return new BinaryLazyLinkedList(this, size6);
                    }
                    case 3: 
                    case 4: {
                        return new BinaryLazySet(this, size6);
                    }
                }
                throw new BinaryObjectException("Unknown collection type: " + colType);
            }
            case 25: {
                return BinaryLazyMap.parseMap(this);
            }
            case 28: {
                return new BinaryBuilderEnum(this);
            }
            case 29: {
                return new BinaryEnumArrayLazyValue(this);
            }
            case 27: {
                int size7 = this.readInt();
                this.pos += size7;
                int start = this.readInt();
                BinaryObjectImpl binaryObj = new BinaryObjectImpl(this.ctx, this.arr, this.pos - 4 - size7 + start);
                return new BinaryPlainBinaryObject(binaryObj);
            }
            case -2: {
                BinaryHeapInputStream bin = BinaryHeapInputStream.create(this.arr, this.pos);
                Object obj = BinaryUtils.doReadOptimized(bin, this.ctx, U.resolveClassLoader(this.ctx.configuration()));
                this.pos = bin.position();
                return obj;
            }
            default: {
                throw new BinaryObjectException("Invalid flag value: " + type);
            }
        }
        BinaryAbstractLazyValue res = modifiableLazyVal ? new BinaryModifiableLazyValue(this, valPos, 1 + plainLazyValLen) : new BinaryPlainLazyValue(this, valPos, 1 + plainLazyValLen);
        this.pos += plainLazyValLen;
        return res;
    }

    public byte[] array() {
        return this.arr;
    }

    public int position() {
        return this.pos;
    }

    public void position(int pos) {
        this.pos = pos;
    }

    public void skip(int n) {
        this.pos += n;
    }

    BinaryReaderExImpl reader() {
        return this.reader;
    }

    private class LazyCollection
    implements BinaryLazyValue {
        private final int valOff;
        private Object col;

        protected LazyCollection(int valOff) {
            this.valOff = valOff;
        }

        private Object wrappedCollection() {
            if (this.col == null) {
                BinaryBuilderReader.this.position(this.valOff);
                this.col = BinaryBuilderReader.this.parseValue();
            }
            return this.col;
        }

        @Override
        public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
            ctx.writeValue(writer, this.wrappedCollection());
        }

        @Override
        public Object value() {
            return BinaryUtils.unwrapLazy(this.wrappedCollection());
        }
    }
}

